package com.bokesoft.yigo.meta.taskflow;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.taskflow.node.MetaCompensation;
import com.bokesoft.yigo.meta.taskflow.node.MetaEnd;
import com.bokesoft.yigo.meta.taskflow.node.MetaFork;
import com.bokesoft.yigo.meta.taskflow.node.MetaJoin;
import com.bokesoft.yigo.meta.taskflow.node.MetaNode;
import com.bokesoft.yigo.meta.taskflow.node.MetaNodeCollection;
import com.bokesoft.yigo.meta.taskflow.node.MetaStart;
import com.bokesoft.yigo.meta.taskflow.node.MetaState;
import com.bokesoft.yigo.meta.taskflow.node.MetaTask;

/**
 * 任务流程
 */
public class MetaTaskFlow extends AbstractMetaObject {
	
	public final static String TAG_NAME = "TaskFlow";
	/** 唯一标识 */
	private String key = null;
	/** 名称 */
	private String caption = null;
	/** 节点集合 */
	private MetaNodeCollection nodes = null;
	
	private String startNode = null;
	
	/** 对工程的引用 */
	private IMetaProject project = null;
	
	public MetaTaskFlow() {
		nodes = new MetaNodeCollection();
	}
	
	/**
	 * 获取唯一标识
	 * @return 唯一标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置唯一标识
	 * @param key 唯一标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 获取名称
	 * @return 名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/**
	 * 设置名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 获取节点集合
	 * @return 节点集合
	 */
	public MetaNodeCollection getNodeCollection() {
		return this.nodes;
	}
	
	/**
	 * 设置节点集合
	 * @param nodes 节点集合
	 */
	public void setNodeCollection(MetaNodeCollection nodes) {
		this.nodes = nodes;
	}
	
	/**
	 * 获取开始节点
	 * @return 开始节点
	 */
	public MetaStart getStart() {
		if(startNode == null || startNode.isEmpty()) {
			for(MetaNode node : nodes) {
				if(node instanceof MetaStart) {
					startNode = node.getKey();
					return (MetaStart) node;
				}
			}
		}
		
		return (MetaStart)nodes.get(startNode);
	}
	
	/**
	 * 获取工程引用
	 * @return 工程引用
	 */
	public IMetaProject getProject() {
		return this.project;
	}

	/**
	 * 设置工程引用
	 * @param project 工程引用
	 */
	public void setProject(IMetaProject project) {
		this.project = project;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] {nodes});
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		MetaNode n = null;
		if ( MetaStart.TAG_NAME.equals(tagName) ) {
			n = new MetaStart();
			n.preProcessMetaObject(env, doc, node, flag, runType);
			nodes.add(n);
			resultMetaObject = n;
		} else if(MetaEnd.TAG_NAME.equals(tagName)) {
			n = new MetaEnd();
			n.preProcessMetaObject(env, doc, node, flag, runType);
			nodes.add(n);
			resultMetaObject = n;
		} else if(MetaFork.TAG_NAME.equals(tagName)) {
			n = new MetaFork();
			n.preProcessMetaObject(env, doc, node, flag, runType);
			nodes.add(n);
			resultMetaObject = n;
		} else if(MetaJoin.TAG_NAME.equals(tagName)) {
			n = new MetaJoin();
			n.preProcessMetaObject(env, doc, node, flag, runType);
			nodes.add(n);
			resultMetaObject = n;
		} else if(MetaTask.TAG_NAME.equals(tagName)) {
			n = new MetaTask();
			n.preProcessMetaObject(env, doc, node, flag, runType);
			nodes.add(n);
			resultMetaObject = n;	
		} else if(MetaCompensation.TAG_NAME.equals(tagName)) {
			n = new MetaCompensation();
			n.preProcessMetaObject(env, doc, node, flag, runType);
			nodes.add(n);
			resultMetaObject = n;	
		} else if(MetaState.TAG_NAME.equals(tagName)) {
			n = new MetaState();
			n.preProcessMetaObject(env, doc, node, flag, runType);
			nodes.add(n);
			resultMetaObject = n;	
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTaskFlow clone = new MetaTaskFlow();
		clone.setKey(key);
		clone.setCaption(caption);
		clone.setNodeCollection(nodes == null ? null : (MetaNodeCollection)nodes.clone());
		clone.setProject(project);
		return clone;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTaskFlow();
	}

}
