package com.bokesoft.yigo.meta.solution;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.app.MetaApps;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.calendar.MetaWorkingCalendarCollection;
import com.bokesoft.yigo.meta.common.MetaInplaceToolbarCollection;
import com.bokesoft.yigo.meta.common.MetaMidProcessFlowCollection;
import com.bokesoft.yigo.meta.intf.IMetaSolution;
import com.bokesoft.yigo.meta.strings.MetaStringTable;

/**
 * MetaSolution类定义解决方案的基本信息，包含标识名称和启动工程以及工程的列表。
 * 
 * @author 王元和
 * @see MetaProjectCollection
 */
public class MetaSolution extends AbstractMetaObject implements IMetaSolution, IElementMerge<MetaSolution> {
	/** 应用标识 */
	private String key = "";
	/** 应用名称 */
	private String caption = "";
	/** 路径 */
	private String dataPath = "";
	/** 启动表单 */
	private String startForm = "";
	/** 安全等级 */
	private Integer securityLevel = 10;
	/** 是否启用多语种 */
	private Boolean enableMultiLang = false;
	/** 默认语言 */
	private String defaultLang = "zh-CN";
	/** 开发测试用语言 */
	private String testLang = "";
	/** 工程集合 */
	private MetaProjectCollection projectCollection = null;
	/** 融合工具栏集合 */
	private MetaInplaceToolbarCollection inplaceToolBarCollection = null;
	/** 中间层扩展处理流集合 */
	private MetaMidProcessFlowCollection midProcessFlowCollection = null;
	/** 工作日历设置 */
	private MetaWorkingCalendarCollection workingCalendarCollection = null;
	/** 启动项集合 */
	private MetaStartItemCollection startItemCollection = null;
	/** 需要登陆打开的表单项集合*/
	private MetaPreLoadItemCollection preLoadItemCollection = null;
	/** 服务端定时任务集合*/
	private MetaScheduleJobCollection scheduleJobCollection = null;
	/** 国际化语种定义*/
	private MetaLangConfig langConfig = null;
	/** 多应用定义 */
	private MetaApps apps = null;
	/** 设计器自定义配置编辑界面扩展类 */
	private String designEditorFactory = null;
	/** 是否启用差异 */
	private Boolean enableDiff = false;
	
	public MetaSolution() {
		projectCollection = new MetaProjectCollection();
		langConfig = new MetaLangConfig();
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { projectCollection, inplaceToolBarCollection,
				midProcessFlowCollection, workingCalendarCollection, startItemCollection,preLoadItemCollection,
				this.apps,langConfig});
	}

	public static final String TAG_NAME = "Solution";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaProjectCollection.TAG_NAME.equals(tagName)) {
			projectCollection.preProcessMetaObject(env, doc, node, flag, runType);
			resultMetaObject = projectCollection;
		} else if (MetaInplaceToolbarCollection.TAG_NAME.equals(tagName)) {
			inplaceToolBarCollection = new MetaInplaceToolbarCollection();
			resultMetaObject = inplaceToolBarCollection;
		} else if (MetaMidProcessFlowCollection.TAG_NAME.equals(tagName)) {
			midProcessFlowCollection = new MetaMidProcessFlowCollection();
			resultMetaObject = midProcessFlowCollection;
		} else if (MetaWorkingCalendarCollection.TAG.equals(tagName)) {
			workingCalendarCollection = new MetaWorkingCalendarCollection();
			resultMetaObject = workingCalendarCollection;
		} else if(MetaBPMSetting.TAG_NAME.equals(tagName)){
			resultMetaObject=new MetaBPMSetting();
		} else if ( MetaStartItemCollection.TAG_NAME.equals(tagName) ) {
			this.startItemCollection = new MetaStartItemCollection();
			startItemCollection.preProcessMetaObject(env, doc, node, flag, runType);
			resultMetaObject = this.startItemCollection;
		} else if( MetaPreLoadItemCollection.TAG_NAME.equalsIgnoreCase(tagName) ) {
			this.preLoadItemCollection = new MetaPreLoadItemCollection();
			resultMetaObject = this.preLoadItemCollection;
		} else if( MetaScheduleJobCollection.TAG_NAME.equalsIgnoreCase(tagName) ) {
			this.scheduleJobCollection = new MetaScheduleJobCollection();
			resultMetaObject = this.scheduleJobCollection;
		} else if ( MetaApps.TAG_NAME.equals(tagName) ) {
			this.apps = new MetaApps();
			resultMetaObject = this.apps;
		} else if( MetaLangConfig.TAG_NAME.equals(tagName)){
			resultMetaObject = this.langConfig;
		}
		return resultMetaObject;
	}

	/**
	 * 设置应用标识
	 * 
	 * @param key
	 *            应用标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 取得应用标识
	 * 
	 * @return 应用标识
	 */
	public String getKey() {
		return key;
	}

	/**
	 * 设置应用名称
	 * 
	 * @param caption
	 *            应用名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}

	/**
	 * 取得应用名称
	 * 
	 * @return 应用名称
	 */
	public String getCaption() {
		return caption;
	}

	/**
	 * 设置启动表单
	 * 
	 * @param startForm
	 *            启动表单
	 */
	public void setStartForm(String startForm) {
		this.startForm = startForm;
	}

	/**
	 * 取得启动表单
	 * 
	 * @return 启动表单
	 */
	public String getStartForm() {
		return startForm;
	}
	
	/**
	 * 设置安全等级
	 * @param securityLevel 安全等级
	 */
	public void setSecurityLevel(Integer securityLevel) {
		this.securityLevel = securityLevel;
	}
	
	/**
	 * 取得安全等级
	 * @return 安全等级
	 */
	public Integer getSecurityLevel() {
		return this.securityLevel;
	}

	/**
	 * 获取设计器自定义配置编辑界面扩展类
	 *  
	 * @return 编辑界面扩展类
	 */
	public String getDesignEditorFactory() {
		return this.designEditorFactory;
	}
	
	/**
	 * 设置设计器自定义配置编辑界面扩展类
	 */
	public void setDesignEditorFactory(String designEditorFactory) {
		this.designEditorFactory = designEditorFactory;
	}
	
	/**
	 * 取得工程集合
	 * 
	 * @return 工程集合
	 */
	public MetaProjectCollection getProjectCollection() {
		return this.projectCollection;
	}

	/**
	 * 根据工程标识取得工程元数据
	 * 
	 * @param projectKey
	 *            工程标识
	 * @return 如果相应的工程存在，返回工程元数据，否则返回null
	 */
	public MetaProject getProject(String projectKey) {
		MetaProjectProfile metaProjectProfile = projectCollection
				.get(projectKey);
		if (metaProjectProfile != null) {
			return metaProjectProfile.getProject();
		}
		return null;
	}

	/**
	 * 设置融合工具栏集合
	 * 
	 * @param inplaceToolBarCollection 融合工具栏集合
	 */
	public void setInplaceToolBarCollection(
			MetaInplaceToolbarCollection inplaceToolBarCollection) {
		this.inplaceToolBarCollection = inplaceToolBarCollection;
	}

	/**
	 * 取得融合工具栏集合
	 * 
	 * @return 融合工具栏集合
	 */
	public MetaInplaceToolbarCollection getInplaceToolBarCollection() {
		return this.inplaceToolBarCollection;
	}

	/**
	 * 设置中间层处理流集合
	 * 
	 * @param midProcessFlowCollection 中间层处理流集合
	 */
	public void setMidProcessFlowCollection(
			MetaMidProcessFlowCollection midProcessFlowCollection) {
		this.midProcessFlowCollection = midProcessFlowCollection;
	}

	/**
	 * 取得中间层处理流集合
	 * 
	 * @return 中间层处理流集合
	 */
	public MetaMidProcessFlowCollection getMidProcessFlowCollection() {
		return this.midProcessFlowCollection;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * 取得工作日历定义集合
	 * @return 工作日历定义集合
	 */
	public MetaWorkingCalendarCollection getWorkingCalendarCollection() {
		return workingCalendarCollection;
	}

	/**
	 * 设置工作日历定义集合
	 * @param workingCalendarCollection 工作日历定义集合
	 */
	public void setWorkingCalendarCollection(
			MetaWorkingCalendarCollection workingCalendarCollection) {
		this.workingCalendarCollection = workingCalendarCollection;
	}

	/**
	 * 取得附件类数据的存放路径
	 * @return 服务器端路径
	 */
	public String getDataPath() {
		return dataPath;
	}

	/**
	 * 设置附件类数据的存放路径
	 * @param dataPath 服务器端路径
	 */
	public void setDataPath(String dataPath) {
		this.dataPath = dataPath;
	}
	
	/**
	 * 设置是否启用多语种
	 * @param enableMultiLang 启用标志
	 */
	public void setEnableMultiLang(Boolean enableMultiLang) {
		this.enableMultiLang = enableMultiLang;
	}
	
	/**
	 * 取得是否启用多语种
	 * @return 启用标志
	 */
	public Boolean isEnableMultiLang() {
		return this.enableMultiLang;
	}
	
	/**
	 * 设置默认语种
	 * @param defaultLang 语种
	 */
	public void setDefaultLang(String defaultLang) {
		this.defaultLang = defaultLang;
	}
	
	/**
	 * 取得默认语种
	 * @return 默认语种
	 */
	public String getDefaultLang() {
		return this.defaultLang;
	}
	
	/**
	 * 设置启动项集合
	 * @param startItemCollection 启动项集合
	 */
	public void setStartItemCollection(MetaStartItemCollection startItemCollection) {
		this.startItemCollection = startItemCollection;
	}
	
	/**
	 * 取得启动项集合
	 * @return 启动项集合
	 */
	public MetaStartItemCollection getStartItemCollection() {
		return this.startItemCollection;
	}
	
	/**
	 * 获取需要预先打开的表单项集合
	 * @return 预先打开的表单项集合
	 */
	public MetaPreLoadItemCollection getPreLoadItemCollection() {
		return preLoadItemCollection;
	}
	
	/**
	 * 设值需要预先打开的表单项集合
	 * 
	 * @param preLoadItemCollection 预先打开的表单项集合
	 */
	public void setPreLoadItemCollection(
			MetaPreLoadItemCollection preLoadItemCollection) {
		this.preLoadItemCollection = preLoadItemCollection;
	}

	/**
	 * 获取定时任务集合
	 * @return 定时任务集合
	 */
	public MetaScheduleJobCollection getScheduleJobCollection() {
		return scheduleJobCollection;
	}

	/**
	 * 设置定时任务集合
	 * @param scheduleJobCollection 定时任务集合
	 */
	public void setScheduleJobCollection(
			MetaScheduleJobCollection scheduleJobCollection) {
		this.scheduleJobCollection = scheduleJobCollection;
	}

	/**
	 * 取得启动表单
	 * @param platform 设备标识
	 * @return 启动表单标识，如果不存在则返回""
	 */
	public String getStartForm(String platform) {
		String startForm = "";
		if ( this.startItemCollection != null ) {
			MetaStartItem startItem = this.startItemCollection.get(platform);
			if ( startItem != null ) {
				startForm = startItem.getStartForm();
			}
		}
		if ( startForm == null || startForm.isEmpty() ) {
			startForm = this.startForm;
		}
		if ( startForm == null || startForm.isEmpty() ) {
			startForm = "Workspace";
		}
		return startForm;
	}
	
	/**
	 * 设置测试语言
	 * @param testLang 测试语言
	 */
	public void setTestLang(String testLang) {
		this.testLang = testLang;
	}
	
	/**
	 * 取得测试语言
	 * @return 测试语言
	 */
	public String getTestLang() {
		return this.testLang;
	}
	
	/** 字符串表 */
	private MetaStringTable strings = null;
	
	/**
	 * 设置字符串表
	 * @param strings 字符串表
	 */
	public void setStrings(MetaStringTable strings) {
		this.strings = strings;
	}
	
	/**
	 * 取得字符串表
	 * @return 字符串表
	 */
	public MetaStringTable getStrings() {
		return this.strings;
	}
	
	/** 数据映射多语种字符串*/
	private MetaStringTable dataMapStrings = null;
	
	
	
	public MetaStringTable getDataMapStrings() {
		return dataMapStrings;
	}

	public void setDataMapStrings(MetaStringTable dataMapStrings) {
		this.dataMapStrings = dataMapStrings;
	}
	
	/** 数据迁移多语种字符串*/
	private MetaStringTable dataMigrationStrings = null;

	public MetaStringTable getDataMigrationStrings() {
		return dataMigrationStrings;
	}

	public void setDataMigrationStrings(MetaStringTable dataMigrationStrings) {
		this.dataMigrationStrings = dataMigrationStrings;
	}

	/**
	 * 设置多应用定义
	 * @param apps 多应用定义
	 */
	public void setApps(MetaApps apps) {
		this.apps = apps;
	}
	
	/**
	 * 取得多应用定义
	 * @return 多应用定义
	 */
	public MetaApps getApps() {
		return this.apps;
	}
	
	public MetaLangConfig getLangConfig(){
		return this.langConfig;
	}

	public void setLangConfig(MetaLangConfig langConfig) {
		this.langConfig = langConfig;
	}
	
	public Boolean isEnableDiff() {
		return this.enableDiff;
	}

	public void setEnableDiff(Boolean b) {
		this.enableDiff = b;
	}

	@Override
	public MetaSolution toMerge(MetaSolution obj) {
		if (obj != null) {
			if (projectCollection != null) {
				projectCollection.toMerge(obj.projectCollection);
			}
			if (preLoadItemCollection != null) {
				preLoadItemCollection.toMerge(obj.preLoadItemCollection);
			}
		}
		return this;
	}
	
	
}
