package com.bokesoft.yigo.meta.solution;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.common.def.PlatformType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.enhance.MetaEnhance;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.intf.IMetaSolution;
import com.bokesoft.yigo.meta.mobiledef.MetaMobileDef;
import com.bokesoft.yigo.meta.path.MetaSecurityFilter;
import com.bokesoft.yigo.meta.strings.MetaStringTable;

/**
 * MetaProject定义工程的元文件，包含标识和名称两个属性，以及对其它元数据的引用，包括
 * <ul>
 * 	<li>MetaFormList表单元数据集合
 * 	<li>MetaDataObjectList数据对象元数据集合
 * </ul>
 * 这些关联的元数据对象通过外部的读取代码设置进来，由元数据装裁程序负责。
 * 
 * @author 王元和
 * @see com.bokesoft.yigo.meta.form.MetaFormList
 * @see com.bokesoft.yigo.meta.dataobject.MetaDataObjectList
 */
public class MetaProject extends AbstractMetaObject implements IMetaProject {
	/** 工程标识 */
	private String key = "";
	/** 工程名称 */
	private String caption = "";
	/** 路径 */
	private String dataPath = "";
	/** 父工程 */
	private String parentProject = "";
	/** 支持的平台列表 */
	private Integer platform = PlatformType.All;
	/** 应用引用 */
	private IMetaSolution solution = null;
	/** 工程下的公共定义 */
	private MetaCommonDef commonDef = null;
	/** 工程下的移动端定义 */
	private MetaMobileDef mobileDef = null;
	/** 工程下安全过滤定义*/
	private MetaSecurityFilter securityFilter = null;
	/** 工程下的功能扩展 */
	private MetaEnhance enhance = null;
	/** 差异工程指向 */
	private String diffProject = "";
	/** 是否是差异工程, 设计器加载时动态设置,不需要保存到配置中 */
	private boolean isDiffProject = false;
	
	public MetaProject() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "Project";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		return null;
	}
	
	/**
	 * 设置应用的引用
	 * @param solution IMetaSolution接口，可以转成MetaSolution
	 */
	public void setSolution(IMetaSolution solution) {
		this.solution = solution;
	}
	
	/**
	 * 取得应用的引用
	 * @return IMetaSolution接口，可以转成MetaSolution接口
	 */
	public IMetaSolution getSolution() {
		return this.solution;
	}
	
	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得标识
	 * @return 标识
	 */
	public String getKey() {
		return key;
	}
	
	/**
	 * 设置名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得名称
	 * @return 名称
	 */
	public String getCaption() {
		return caption;
	}
	
	/**
	 * 设置父工程
	 * @param parentProject 父工程
	 */
	public void setParentProject(String parentProject) {
		this.parentProject = parentProject;
	}
	
	/**
	 * 取得父工程
	 * @return 父工程
	 */
	public String getParentProject() {
		return parentProject;
	}
	
	/**
	 * 设置支持的平台列表
	 * @param platform 平台标识列表
	 */
	public void setPlatform(int platform) {
		this.platform = platform;
	}
	
	/**
	 * 取得支持的平台列表
	 * @return 平台标识列表
	 */
	public Integer getPlatform() {
		return this.platform;
	}
	
	/**
	 * 设置公共定义引用
	 * @param commonDef 公共定义
	 */
	public void setCommonDef(MetaCommonDef commonDef) {
		this.commonDef = commonDef;
	}
	
	/**
	 * 取得公共定义引用
	 * @return 公共定义
	 */
	public MetaCommonDef getCommonDef() {
		return this.commonDef;
	}
	
	/**
	 * 设置移动端定义
	 * @param mobileDef 移动端定义
	 */
	public void setMobileDef(MetaMobileDef mobileDef) {
		this.mobileDef = mobileDef;
	}
	
	/**
	 * 获取移动端定义
	 * @return 移动端定义
	 */
	public MetaMobileDef getMobileDef() {
		return mobileDef;
	}

	/**
	 * 设置功能扩展定义
	 * @param enhance 功能扩展定义
	 */
	public void setEnhance(MetaEnhance enhance) {
		this.enhance = enhance;
	}
	
	/**
	 * 取得功能扩展定义
	 * @return 功能扩展定义
	 */
	public MetaEnhance getEnhance() {
		return this.enhance;
	}
	
	public void setSecurityFilter(MetaSecurityFilter securityFilter) {
		this.securityFilter = securityFilter;
	}
	
	public MetaSecurityFilter getSecurityFilter() {
		return securityFilter;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getDataPath() {
		return dataPath;
	}

	public void setDataPath(String dataPath) {
		this.dataPath = dataPath;
	}
	
	/** 字符串表 */
	private MetaStringTable strings = null;
	
	/**
	 * 设置字符串表
	 * @param strings 字符串表
	 */
	public void setStrings(MetaStringTable strings) {
		ProjectI18nHolder.setStrings(this.key, strings);
	}
	
	/**
	 * 取得字符串表
	 * @return 字符串表
	 */
	public MetaStringTable getStrings() {
		return ProjectI18nHolder.getStrings(this.key);
	}
	
	/** 数据映射下的多语种字符串*/
	private MetaStringTable dataMapStrings = null;

	public MetaStringTable getDataMapStrings() {
		return ProjectI18nHolder.getDataMapStrings(this.key);
	}

	public void setDataMapStrings(MetaStringTable dataMapStrings) {
		ProjectI18nHolder.setDataMapStrings(this.key, dataMapStrings);
	}
	
	/** 数据迁移下的多语种字符串*/
	private MetaStringTable dataMigrationStrings = null;

	public MetaStringTable getDataMigrationStrings() {
		return ProjectI18nHolder.getDataMigrationStrings(this.key);
	}

	public void setDataMigrationStrings(MetaStringTable dataMigrationStrings) {
		ProjectI18nHolder.setDataMigrationStrings(this.key, dataMigrationStrings);
	}
	
	/**
	 * 指向差异工程
	 * 
	 * @param diffProject
	 */
	public void setDiffProject(String diffProject) {
		this.diffProject = diffProject;
	}
	
	public boolean isReferOtherDiffProject() {
		return !StringUtil.isBlankOrNull(diffProject) && !diffProject.equalsIgnoreCase(key);
	}

	public void setAsDiffProject() {
		this.isDiffProject = true;
	}
	
	public boolean isDiffProject() {
		return this.isDiffProject;
	}
}
