package com.bokesoft.yigo.meta.solution;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaPreLoadItemCollection extends GenericKeyCollection<MetaPreLoadItem> implements IElementMerge<MetaPreLoadItemCollection> {

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}
	
	public static final String TAG_NAME = "PreLoadItemCollection";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		MetaPreLoadItem child = null;
		if ( MetaPreLoadItem.TAG_NAME.equals(tagName) ) {
			child = new MetaPreLoadItem();
		}
		if ( child != null ) {
			child.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(child);
		}
		return child;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaPreLoadItemCollection();
	}

	@Override
	public MetaPreLoadItemCollection toMerge(MetaPreLoadItemCollection obj) {
		if (obj != null) {
            for (MetaPreLoadItem metaPreLoadItem : obj) {
                add(metaPreLoadItem);
            }
		}
		return this;
	}

}
