package com.bokesoft.yigo.meta.report;

/**
 * ReportRowType定义报表中行的类型
 * @author 王元和
 * @since YES 1.0
 *
 */
public class ReportRowType {
	

	/** 表格标题头 */
	public static final int TableTitleHead = 4;
	public static final String STR_TableTitleHead = "TableTitleHead";
	
	/** 明细头 */
	public static final int DetailHead = 5;
	public static final String STR_DetailHead = "DetailHead";
	
	/** 表格段落 */
	public static final int TableParagraph = 6;
	public static final String STR_TableParagraph = "TableParagraph";
	
	/** 承上行 */
	public static final int LinkPrev = 7;
	public static final String STR_LinkPrev = "LinkPrev";
	
	/** 明细行 */
	public static final int Detail = 8;
	public static final String STR_Detail = "Detail";

	/** 分组行 */
	public static final int Group = 9;
	public static final String STR_Group = "Group";
	
	/** 启下行 */
	public static final int LinkNext = 10;
	public static final String STR_LinkNext = "LinkNext";
	
	/** 明细尾 */
	public static final int DetailTail = 11;
	public static final String STR_DetailTail = "DetailTail";
	
	/** 表格标题尾 */
	public static final int TableTitleTail = 12;
	public static final String STR_TableTitleTail = "TableTitleTail";
	
	public static int parse(String s) {
		int type = -1;
		if ( STR_TableTitleHead.equalsIgnoreCase(s) ) {
			type = TableTitleHead;
		} else if ( STR_DetailHead.equalsIgnoreCase(s) ) {
			type = DetailHead;
		} else if ( STR_TableParagraph.equalsIgnoreCase(s) ) {
			type = TableParagraph;
		} else if ( STR_LinkPrev.equalsIgnoreCase(s) ) {
			type = LinkPrev;
		} else if ( STR_Detail.equalsIgnoreCase(s) ) {
			type = Detail;
		} else if ( STR_Group.equalsIgnoreCase(s) ) {
			type = Group;
		} else if ( STR_LinkNext.equalsIgnoreCase(s) ) {
			type = LinkNext;
		} else if ( STR_DetailTail.equalsIgnoreCase(s) ) {
			type = DetailTail;
		} else if ( STR_TableTitleTail.equalsIgnoreCase(s) ) {
			type = TableTitleTail;
		}
		return type;
	}
	
	public static String toString(Integer type) {
		if(type == null) {
			return "";
		}
		String s = "";
		switch ( type ) {
		case TableTitleHead:
			s = STR_TableTitleHead;
			break;
		case DetailHead:
			s = STR_DetailHead;
			break;
		case TableParagraph:
			s = STR_TableParagraph;
			break;
		case LinkPrev:
			s = STR_LinkPrev;
			break;
		case Detail:
			s = STR_Detail;
			break;
		case Group:
			s = STR_Group;
			break;
		case LinkNext:
			s = STR_LinkNext;
			break;
		case DetailTail:
			s = STR_DetailTail;
			break;
		case TableTitleTail:
			s = STR_TableTitleTail;
			break;
		}
		return s;
	}
}
