package com.bokesoft.yigo.meta.report;

/**
 * ReportContentSourceType定义报表中的单元格的数据来源
 * @author 王元和
 * @since YES 1.0
 *
 */
public class ReportContentSourceType {
	/** 单元格的数据来源于字段域 */
	public static final int Field = 0;
	public static final String STR_Field = "Field";
	
	/** 单元格的数据来源于表达式 */
	public static final int Formula = 1;
	public static final String STR_Formula = "Formula";
	
	/** 单元格的数据来源于接口 */
	public static final int Interface = 2;
	public static final String STR_Interface = "Interface";
	
	/** 单元格的数据来源于页码 */
	public static final int PageNo = 3;
	public static final String STR_PageNo = "PageNo";
	
	/** 单元格的数据来源于常量 */
	public static final int Const = 4;
	public static final String STR_Const = "Const";
	
	/** 单元格数据来源于系统域 */
	public static final int System = 5;
	public static final String STR_System = "System";
	
	/**
	 * 从字符串解析类型
	 * @param s 字符串
	 * @return 类型
	 */
	public static int parse(String s) {
		int type = -1;
		if ( STR_Field.equalsIgnoreCase(s) ) {
			type = Field;
		} else if ( STR_Formula.equalsIgnoreCase(s) ) {
			type = Formula;
		} else if ( STR_Interface.equalsIgnoreCase(s) ) {
			type = Interface;
		} else if ( STR_PageNo.equalsIgnoreCase(s) ) {
			type = PageNo;
		} else if ( STR_Const.equalsIgnoreCase(s) ) {
			type = Const;
		} else if ( STR_System.equalsIgnoreCase(s) ) {
			type = System;
		}
		return type;
	}
	
	/**
	 * 从类型取得字符串表示
	 * @param type 类型
	 * @return 字符串表示
	 */
	public static String toString(Integer type) {
		if(type == null) 
			return "";
		
		String s = "";
		switch ( type ) {
		case Field:
			s = STR_Field;
			break;
		case Formula:
			s = STR_Formula;
			break;
		case Interface:
			s = STR_Interface;
			break;
		case PageNo:
			s = STR_PageNo;
			break;
		case Const:
			s = STR_Const;
			break;
		case System:
			s = STR_System;
			break;
		}
		return s;
	}
	
	public static String getListString() {
		return "字段" + "," + Field + ";" + "公式" + "," + Formula + ";" + "接口" + "," + Interface;
	}
}
