package com.bokesoft.yigo.meta.report;

public class ReportCellGroupType {
	/** 无分组 */
	public static final int None = 0;
	/** 无分组的字符串表示 */
	public static final String STR_None = "None";
	
	/** 行分组 */
	public static final int RowGroup = 1;
	/** 行分组的字符串表示 */
	public static final String STR_RowGroup = "RowGroup";
	
	/** 树形行分组 */
	public static final int RowTreeGroup = 2;
	/** 树形行分组字符串表示 */
	public static final String STR_RowTreeGroup = "RowTreeGroup";
	
	/**
	 * 根据字符串解析分组类型标识
	 * @param s 分组类型的字符串表示，取值范围为
	 * <ul>
	 * <li>{@link #STR_None}
	 * <li>{@link #STR_RowGroup}
	 * <li>{@link #STR_RowTreeGroup}
	 * </ul>
	 * @return 如果s的取值在定义的范围内，返回相应的分组标识，否则返回-1
	 */
	public static int parse(String s) {
		int groupType = -1;
		if ( STR_None.equalsIgnoreCase(s) ) {
			groupType = None;
		} else if ( STR_RowGroup.equalsIgnoreCase(s) ) {
			groupType = RowGroup;
		} else if ( STR_RowTreeGroup.equalsIgnoreCase(s) ) {
			groupType = RowTreeGroup;
		}
		
		return groupType;
	}
	
	/**
	 * 根据分组类型返回其字符串表示
	 * @param type 分组类型，取值范围为
	 * <ul>
	 * <li>{@link #None}
	 * <li>{@link #RowGroup}
	 * <li>{@link #RowTreeGroup}
	 * </ul>
	 * @return 如果type在取值范围内，返回相应的字符串，否则返回空字符串
	 */
	public static String toString(Integer type) {
		if(type == null)
			return "";
		
		String s = "";
		switch ( type ) {
		case None:
			s = STR_None;
			break;
		case RowGroup:
			s = STR_RowGroup;
			break;
		case RowTreeGroup:
			s = STR_RowTreeGroup;
			break;
		}
		return s;
	}
	
	public static String getListString() {
		return "无分组" + "," + None + ";" + "行分组" + "," + RowGroup + ";" + "树形行分组" + "," + RowTreeGroup;
	}
}
