package com.bokesoft.yigo.meta.report;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaReportWaterprint extends AbstractMetaObject {
	/** 水印来源，为相对于Resource路径的相对路径 */
	private String source = "";
	/** 宽度 */
	private Integer width = 0;
	/** 高度 */
	private Integer height = 0;
	/** 重复标志 */
	private Boolean repeat = true;
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "Waterprint";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaReportWaterprint newObject = new MetaReportWaterprint();
		newObject.setSource(source);
		newObject.setWidth(width);
		newObject.setHeight(height);
		newObject.setRepeat(repeat);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaReportWaterprint();
	}

	/**
	 * 设置来源
	 * @param source 来源
	 */
	public void setSource(String source) {
		this.source = source;
	}
	
	/**
	 * 取得来源
	 * @return 来源
	 */
	public String getSource() {
		return this.source;
	}
	
	/**
	 * 设置宽度
	 * @param width 宽度
	 */
	public void setWidth(Integer width) {
		this.width = width;
	}
	
	/**
	 * 取得宽度
	 * @return 宽度
	 */
	public Integer getWidth() {
		return this.width;
	}
	
	/**
	 * 设置高度
	 * @param height 高度
	 */
	public void setHeight(Integer height) {
		this.height = height;
	}
	
	/**
	 * 取得高度
	 * @return 高度
	 */
	public Integer getHeight() {
		return this.height;
	}
	
	/**
	 * 设置重复标志
	 * @param repeat 重复标志
	 */
	public void setRepeat(Boolean repeat) {
		this.repeat = repeat;
	}
	
	/**
	 * 取得重复标志
	 * @return 重复标志
	 */
	public Boolean isRepeat() {
		return this.repeat;
	}
}
