package com.bokesoft.yigo.meta.permission.filter;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.MappingRelationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaMappingFilter extends AbstractMetaObject {
	
	public static final String TAG_NAME = "MappingFilter";
	/** 源映射的标识*/
	private String sourceMapKey="";
	/** 目标映射的标识*/
	private String targetMapKey="";
	/** 源数据与目标数据之间的包含关系*/
	private Integer relationType = MappingRelationType.CONTAIN;
	/** 源数据*/
	private MetaSourceData sourceData = null;
	/** 目标数据*/
	private MetaTargetData targetData = null;

	public String getSourceMapKey() {
		return sourceMapKey;
	}

	public void setSourceMapKey(String sourceMapKey) {
		this.sourceMapKey = sourceMapKey;
	}

	public String getTargetMapKey() {
		return targetMapKey;
	}

	public void setTargetMapKey(String targetMapKey) {
		this.targetMapKey = targetMapKey;
	}

	public Integer getRelationType() {
		return relationType;
	}

	public void setRelationType(Integer relationType) {
		this.relationType = relationType;
	}

	public MetaSourceData getSourceData() {
		return sourceData;
	}

	public void setSourceData(MetaSourceData sourceData) {
		this.sourceData = sourceData;
	}

	public MetaTargetData getTargetData() {
		return targetData;
	}

	public void setTargetData(MetaTargetData targetData) {
		this.targetData = targetData;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll2(list, sourceData, targetData);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (MetaSourceData.TAG_NAME.equals(tagName)) {
			sourceData = new MetaSourceData();
			child = sourceData;
		}else if (MetaTargetData.TAG_NAME.equals(tagName)) {
			targetData = new MetaTargetData();
			child = targetData;
		}
		return child;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaMappingFilter newObj = new MetaMappingFilter();
		newObj.sourceMapKey = sourceMapKey;
		newObj.targetMapKey = targetMapKey;
		newObj.relationType = relationType;
		newObj.sourceData = sourceData == null ? null : (MetaSourceData)sourceData.clone();
		newObj.targetData = targetData == null ? null : (MetaTargetData)targetData.clone();
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMappingFilter();
	}

}
