package com.bokesoft.yigo.meta.permission.custom;


import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;

import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaServiceRightsCollection;

public class MetaOperation extends KeyPairMetaObject {
	
	public static final String TAG_NAME="Operation";
	/** 操作标识*/
	private String key ="";
	/** 操作名称*/
	private String caption ="";
	
	private MetaServiceRightsCollection serviceRightsCollection = null;
	
	public MetaServiceRightsCollection getServiceRightsCollection() {
		return serviceRightsCollection;
	}

	public void setServiceRightsCollection(MetaServiceRightsCollection serviceRightsCollection) {
		this.serviceRightsCollection = serviceRightsCollection;
	}

	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public String getKey() {
		return key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaOperation newObj = new MetaOperation();
		newObj.key = key;
		newObj.caption = caption;
		MetaServiceRightsCollection collection = new MetaServiceRightsCollection();
		collection = (MetaServiceRightsCollection) serviceRightsCollection.clone();
		newObj.serviceRightsCollection = collection;
		
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaOperation();
	}

}
