package com.bokesoft.yigo.meta.path.check;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 行为权限列表
 * 
 * @author 刘翔翔
 *
 */
public class MetaRelationCheck extends GenericKeyCollection<MetaCheckTarget> implements IElementMerge<MetaRelationCheck>{

	public static final String TAG = "RelationCheck";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		MetaCheckTarget item = null;
		if (tagName.equalsIgnoreCase(MetaDataObject.TAG)) {
			item = new MetaDataObject();
		} else if (tagName.equalsIgnoreCase(MetaScript.TAG)) {
			item = new MetaScript();
		} else if (tagName.equalsIgnoreCase(MetaService.TAG)) {
			item = new MetaService();
		}

		if (item != null) {
			item.preProcessMetaObject(env, doc, node, flag, runType);
			add(item);
		}
		return item;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRelationCheck();
	}

	@Override
	public MetaRelationCheck toMerge(MetaRelationCheck obj) {
		if (obj != null) {
			Iterator<MetaCheckTarget> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaCheckTarget metaCheckTarget = (MetaCheckTarget) iterator.next();
				if (containsKey(metaCheckTarget.getKey())) {
					throw new MetaException(MetaException.REPEAT_RELATION_CHECK_DEFINED,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatRelationCheckDefined),
									metaCheckTarget.getKey()));
				}
				add(metaCheckTarget);
			}
		}
		return this;
	}

}
