package com.bokesoft.yigo.meta.mobiledef;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;


/**
 * 震动定义
 * @author lishu
 *
 */
public class MetaVibratorItem extends KeyPairMetaObject{
	
	/** 类型标识，目前只支持两个值：Shark_once（震动一次）和Shark_loop（循环震动）。*/
	private String key = "";
	/** 震动一次时，持续的时间，单位为毫秒*/
	private Integer milliseconds = 0;
	/** 震动方式，其格式为："100,1000,200,2000,......"，
	 * 其为一个不定长的数组字符串，表示等待100毫秒、震动1000毫秒、等待200毫秒、震动2000毫秒... ...*/
	private String pattern = "";
	/** 设定的震动方式重复的次数。-1为默认值，代表只震动一次；0代表无限重复，直到调用取消震动。*/
	private Integer repeat = -1;
	/** 等待时间，即震动的间隔时间，单位为毫秒*/
	private Integer delayTime = 0;
	
	

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public Integer getMilliseconds() {
		return milliseconds;
	}

	public void setMilliseconds(Integer milliseconds) {
		this.milliseconds = milliseconds;
	}

	public String getPattern() {
		return pattern;
	}

	public void setPattern(String pattern) {
		this.pattern = pattern;
	}

	public Integer getRepeat() {
		return repeat;
	}

	public void setRepeat(Integer repeat) {
		this.repeat = repeat;
	}

	public Integer getDelayTime() {
		return delayTime;
	}

	public void setDelayTime(Integer delayTime) {
		this.delayTime = delayTime;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "VibratorItem";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaVibratorItem meta = new MetaVibratorItem();
		meta.setKey(key);
		meta.setMilliseconds(milliseconds);
		meta.setPattern(pattern);
		meta.setRepeat(repeat);
		meta.setDelayTime(delayTime);
		return meta;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaVibratorItem();
	}
}
