package com.bokesoft.yigo.meta.mobiledef;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;


/**
 * 声音定义
 * @author lishu
 *
 */
public class MetaSoundItem extends KeyPairMetaObject{
	
	/** 声音文件的定义标识 */
	private String key = "";
	/** 声音文件的相对路径，相对于配置的Resource目 */
	private String path = "";
	/** 左声道音量大小，相对值，值在0.0到1.0之间，表示为最大音量的百分比值。
	 * 比如为0.8，则表示为最大音量的80%。注意：Android支持使用，IOS不支持。 */
	private Float leftVolume = 1.0f;
	/** 右声道音量大小，相对值，值在0.0到1.0之间*/
	private Float rightVolume = 1.0f;
	/** 优先级，值越大优先越高，0的优先级最低。注意：Android支持使用，IOS不支持 */
	private Integer priority = 0;
	/** 播放次数，值为整数。-1表示无限循环，0表示不播放，1及以上表示播放次数 */
	private Integer loop = -1;
	/** 播放速率，取值为0.5到2.0。1表示正常速率，0.5代表正常速率的0.5倍 */
	private Float rate = 1f;
	

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public Float getLeftVolume() {
		return leftVolume;
	}

	public void setLeftVolume(Float leftVolume) {
		this.leftVolume = leftVolume;
	}

	public Float getRightVolume() {
		return rightVolume;
	}

	public void setRightVolume(Float rightVolume) {
		this.rightVolume = rightVolume;
	}

	public Integer getPriority() {
		return priority;
	}

	public void setPriority(Integer priority) {
		this.priority = priority;
	}

	public Integer getLoop() {
		return loop;
	}

	public void setLoop(Integer loop) {
		this.loop = loop;
	}

	public Float getRate() {
		return rate;
	}

	public void setRate(Float rate) {
		this.rate = rate;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "SoundItem";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaSoundItem meta = new MetaSoundItem();
		meta.setKey(key);
		meta.setPath(path);
		meta.setLeftVolume(leftVolume);
		meta.setRightVolume(rightVolume);
		meta.setPriority(priority);
		meta.setLoop(loop);
		meta.setRate(rate);
		return meta;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSoundItem();
	}
	
	@Override
	public boolean needPreLoad() {
		return true;
	}
}
