package com.bokesoft.yigo.meta.midsetting;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaMidSetting中间层应用设置对象
 * @author wangyh
 *
 */
public class MetaMidSetting extends AbstractMetaObject {
	/** 数据库表结构描述 */
	private MetaSchemaProvider schemaProvider = null;

	public MetaMidSetting() {
		super();
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(schemaProvider);
	}

	/**
	 * 设置数据表结构描述程序配置
	 * @param schemaProvider 描述配置对象
	 */
	public void setSchemaProvider(MetaSchemaProvider schemaProvider) {
		this.schemaProvider = schemaProvider;
	}
	
	/**
	 * 取得数据库表结构描述程序配置
	 * @return 描述配置对象
	 */
	public MetaSchemaProvider getSchemaProvider() {
		return this.schemaProvider;
	}

	public static final String TAG_NAME = "Setting";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaSchemaProvider.TAG_NAME.equals(tagName) ) {
			schemaProvider = new MetaSchemaProvider();
			resultMetaObject = this.schemaProvider;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return null;
	}

}
