package com.bokesoft.yigo.meta.mapping;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaMapping extends GenericKeyCollectionWithKey<MetaNode> {
	public static final String TAG_NAME="Mapping";
	
	private String key="";
	private String caption="";
	private String impl="";

	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public String getImpl() {
		return impl;
	}

	public void setImpl(String impl) {
		this.impl = impl;
	}

	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public String getKey() {
		return key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		MetaNode child = null;
		if (MetaBegin.TAG_NAME.equals(tagName)) {
			child = new MetaBegin();
		}else if (MetaNormalNode.TAG_NAME.equals(tagName)) {
			child = new MetaNormalNode();
		}else if (MetaJoin.TAG_NAME.equals(tagName)) {
			child = new MetaJoin();
		}else if (MetaComplexJoin.TAG_NAME.equals(tagName)) {
			child = new MetaComplexJoin();
		}else if (MetaEnd.TAG_NAME.equals(tagName)) {
			child = new MetaEnd();
		}
		
		if (child != null) {
			child.preProcessMetaObject(env, doc, node, flag, runType);
			add(child);
		}
		
		return child;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMapping();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaMapping newObj = (MetaMapping)super.clone();
		newObj.key = key;
		newObj.caption = caption;
		newObj.impl = impl;
		return newObj;
	}

}
