package com.bokesoft.yigo.meta.form.component.view.layout;

import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;

/**
 * 表视图布局中行配置对象
 * @author chenzs
 *
 */
public class MetaTableRowLayout extends MetaLayoutItem {
	public static final String TAG_NAME = "TableRowLayout";
	/** 高度*/
	private DefSize height = null;
	/** 宽度*/
	private DefSize width = null;
	/** 权重 */
	private Float weight = 0.0f;

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	/**
	 * 设置高度
	 * @param height 高度
	 */
	public void setHeight(DefSize height) {
		this.height = height;
	}

	/**
	 * 获取高度
	 * @return 高度
	 */
	public DefSize getHeight() {
		return this.height;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaLinearItem();
	}

	/**
	 * 获取宽度
	 * @return 宽度
	 */
	public final DefSize getWidth() {
		return width;
	}

	/**
	 * 设置宽度
	 * @param width 宽度
	 */
	public final void setWidth(DefSize width) {
		this.width = width;
	}

	/**
	 * 获取权重
	 * @return 权重
	 */
	public final Float getWeight() {
		return weight;
	}

	/**
	 * 设置权重
	 * @param weight
	 */
	public final void setWeight(Float weight) {
		this.weight = weight;
	}
}
