package com.bokesoft.yigo.meta.form.component.view.layout;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaFluidTableLayout extends MetaComponentLayout<MetaLayoutRowIndex> {
	/** 列定义 */
	private MetaLayoutColumnCollection columnCollection = null;
	/** 排列的重复数 */
	private Integer repeatCount = 1;
	/** 排列间距 */
	private Integer repeatGap = 0;
	/** 行间距 */
	private Integer rowGap = 0;
	/** 列间距 */
	private Integer columnGap = 0;
	/** 默认行高 */
	private Integer rowHeight = 0;
	
	public MetaFluidTableLayout() {
		super();
	}
	
	@Override
	public int getLayoutType() {
		return LayoutType.LAYOUT_FLUIDTABLE;
	}

	public static final String TAG_NAME = "FluidTableLayout";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	public void setColumnCollection(MetaLayoutColumnCollection columnCollection) {
		this.columnCollection = columnCollection;
	}
	
	public MetaLayoutColumnCollection getColumnCollection() {
		return this.columnCollection;
	}
	
	public void setRepeatCount(Integer repeatCount) {
		this.repeatCount = repeatCount;
	}
	
	public Integer getRepeatCount() {
		return this.repeatCount;
	}
	
	public void setRepeatGap(Integer repeatGap) {
		this.repeatGap = repeatGap;
	}
	
	public Integer getRepeatGap() {
		return this.repeatGap;
	}
	
	public void setRowGap(Integer rowGap) {
		this.rowGap = rowGap;
	}
	
	public Integer getRowGap() {
		return this.rowGap;
	}
	
	public void setColumnGap(Integer columnGap) {
		this.columnGap = columnGap;
	}
	
	public Integer getColumnGap() {
		return this.columnGap;
	}
	
	public void setRowHeight(Integer rowHeight) {
		this.rowHeight = rowHeight;
	}
	
	public Integer getRowHeight() {
		return this.rowHeight;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaLayoutRowIndex.TAG_NAME.equals(tagName) ) {
			MetaLayoutRowIndex metaLayoutRowIndex = new MetaLayoutRowIndex();
			metaLayoutRowIndex.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(metaLayoutRowIndex);
			resultMetaObject = metaLayoutRowIndex;
		} else if ( MetaLayoutColumnCollection.TAG_NAME.equals(tagName) ) {
			columnCollection = new MetaLayoutColumnCollection();
			resultMetaObject = columnCollection;
		}
		if (resultMetaObject == null) {
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		return resultMetaObject;
	}
	
	
	
	@Override
	public AbstractMetaObject clone() {
		MetaFluidTableLayout newObject = (MetaFluidTableLayout)super.clone();
		newObject.setRepeatCount(repeatCount);
		newObject.setRepeatGap(repeatGap);
		newObject.setRowGap(rowGap);
		newObject.setColumnGap(columnGap);
		newObject.setRowHeight(rowHeight);
		newObject.setColumnCollection(columnCollection == null ? null : (MetaLayoutColumnCollection)columnCollection.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFluidTableLayout();
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if (columnCollection.size() < 2) {
			throw new MetaException(MetaException.MISS_COLUMN_DEFINITION, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.MissColumnDefinition), this.getKey()));
		}
	}

}
