package com.bokesoft.yigo.meta.form.component.theme;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaTheme extends GenericNoKeyCollectionWithKey<MetaStyle> {
	private String key = "";
	private String caption = "";
	private String media = "";
	private String rule = "";
	private String cssFile = "";
	private MetaIDThemeCollection classCollection = null;
	private MetaIDThemeCollection componentCollection = null;
	public MetaTheme() {
		super();
	}
	
	public void setKey(String key) {
		this.key = key;
	}
	
	@Override
	public String getKey() {
		return key;
	}
	
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	public String getCaption() {
		return this.caption;
	}
	
	public void setMedia(String media) {
		this.media = media;
	}
	
	public String getMedia() {
		return this.media;
	}
	
	public void setRule(String rule) {
		this.rule = rule;
	}
	
	public String getRule() {
		return this.rule;
	}
	
	public void setCssFile(String cssFile) {
		this.cssFile = cssFile;
	}
	
	public String getCssFile() {
		return this.cssFile;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "Theme";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		MetaStyle metaStyle = new MetaStyle();
		this.add(metaStyle);
		return metaStyle;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaTheme();
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaTheme newTheme = (MetaTheme) super.clone();
		newTheme.setKey(key);
		newTheme.setCaption(caption);
		newTheme.setMedia(media);
		newTheme.setRule(rule);
		newTheme.setCssFile(cssFile);
		newTheme.setComponentThemeCollection(componentCollection == null ? null : (MetaIDThemeCollection) componentCollection.clone());
		newTheme.setClassThemeCollection(classCollection == null ? null : (MetaIDThemeCollection) classCollection.clone());
		return newTheme;
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		componentCollection = new MetaIDThemeCollection();
		classCollection = new MetaIDThemeCollection();
		Iterator<MetaStyle> it = this.iterator();
		MetaStyle metaStyle = null;
		while ( it.hasNext() ) {
			metaStyle = it.next();
			String id = metaStyle.getID();
			if ( id != null && !id.isEmpty() ) {
				char prefix = id.charAt(0);
				// 组件
				if ( prefix == '#' ) {
					String markID = id.substring(1); 
					MetaIDTheme collection = componentCollection.get(markID);
					if ( collection == null ) {
						collection = new MetaIDTheme(markID);
						componentCollection.add(collection);
					}
					collection.add(metaStyle);
				} else if ( prefix == '.' ) {
					// 类
					String markID = id.substring(1);
					MetaIDTheme collection = classCollection.get(markID);
					if ( collection == null ) {
						collection = new MetaIDTheme(markID);
						classCollection.add(collection);
					}
					collection.add(metaStyle);
				}
			}
		}
	}
	
	public MetaIDThemeCollection getComponentThemeCollection() {
		return this.componentCollection;
	}
	
	public void setComponentThemeCollection(MetaIDThemeCollection componentCollection) {
		this.componentCollection = componentCollection;
	}
	
	public MetaIDThemeCollection getClassThemeCollection() {
		return this.classCollection;
	}
	
	public void setClassThemeCollection(MetaIDThemeCollection classCollection) {
		this.classCollection = classCollection;
	}
}
