package com.bokesoft.yigo.meta.form.component.panel.customlayoutpanel;

import java.util.Iterator;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDefCollection;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDefCollection;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaCustomLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSpan;

public class MetaCustomLayoutPanel extends MetaPanel {

	public static final String TAG_NAME = ControlType.STR_CUSTOMLAYOUTPANEL;

	/** 行定义集合 */
	private MetaRowDefCollection rowDefCollection = null;
	/** 列定义集合 */
	private MetaColumnDefCollection columnDefCollection = null;

	/**
	 * 设置行定义集合
	 * @param rowDefCollection
	 */
	public void setRowDefCollection(MetaRowDefCollection rowDefCollection) {
		this.rowDefCollection = rowDefCollection;
	}

	/**
	 * 获取行定义集合
	 */
	public MetaRowDefCollection getMetaRowDefCollection() {
		return this.rowDefCollection;
	}

	/**
	 * 设置列定义集合
	 * @param columnDefCollection
	 */
	public void setColumnDefCollection(MetaColumnDefCollection columnDefCollection) {
		this.columnDefCollection = columnDefCollection;
	}

	/**
	 * 获取列定义集合
	 */
	public MetaColumnDefCollection getMetaColumnDefCollection() {
		return this.columnDefCollection;
	}

	/**
	 * 从自定义表格面板的配置中生成表格布局
	 * @return 网格布局
	 */
	public MetaCustomLayout newLayout() {
		MetaCustomLayout layout = new MetaCustomLayout();
		layout.setRowDefCollection(rowDefCollection);
		layout.setColumnDefCollection(columnDefCollection);
		
		Iterator<MetaComponent> it = this.componentArray.iterator();
		MetaComponent metaComponent = null;
		while ( it.hasNext() ) {
			metaComponent = it.next();
			MetaLayoutSpan item = new MetaLayoutSpan();
			item.setKey(metaComponent.getKey());
			item.setX(metaComponent.getX());
			item.setY(metaComponent.getY());
			item.setXSpan(metaComponent.getXSpan());
			item.setYSpan(metaComponent.getYSpan());
			item.setControlType(metaComponent.getControlType());
			layout.add(item);
		}
		
		return layout;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject metaObject = null;
		if (MetaRowDefCollection.TAG_NAME.equalsIgnoreCase(tagName)) {
			rowDefCollection = new MetaRowDefCollection();
			metaObject = rowDefCollection;
		} else if (MetaColumnDefCollection.TAG_NAME.equalsIgnoreCase(tagName)) {
			columnDefCollection = new MetaColumnDefCollection();
			metaObject = columnDefCollection;
		} else {
			metaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		return metaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaGridLayoutPanel newObject = (MetaGridLayoutPanel)super.clone();
		newObject.setRowDefCollection(rowDefCollection == null ? null : (MetaRowDefCollection)rowDefCollection.clone());
		newObject.setColumnDefCollection(columnDefCollection == null ? null : (MetaColumnDefCollection)columnDefCollection.clone());
		return newObject;
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.CUSTOMLAYOUTPANEL;
	}

	@Override
	public AbstractMetaObject getProperties() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCustomLayoutPanel();
	}

}
