package com.bokesoft.yigo.meta.form.component.panel;

import java.util.ArrayList;
import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.SlidingPosition;
import com.bokesoft.yigo.common.def.SlidingType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;

public class MetaSlidingLayoutPanel extends MetaComponent{

	public static final String TAG_NAME =ControlType.STR_SLIDINGLAYOUTPANEL;
	
	/**主显示组件*/
	private MetaComponent mainComponent;
	/**主侧滑组件*/
	private MetaComponent firstComponent;
	/**次侧滑组件*/
	private MetaComponent secondComponent;
	
	/**侧滑样式，默认为抽屉式。其值为：Sliding-侧滑样式，Drawer-抽屉样式，Toggle-缩放侧滑样式*/
	private Integer style = SlidingType.DRAWER; 
	/**侧滑组件所在方向，只存在主侧滑组件时有效。
	 * 当主次侧滑组件都存在时，该属性无效，主侧滑组件默认在左边，次侧滑组件默认在右边*/
	private Integer slidingPosition = SlidingPosition.LEFT;
	/**左侧滑组件的宽度，根据slidingPosition生效*/
	private DefSize leftWidth = DefSize.parse("200px");
	/**右侧滑组件的宽度，根据slidingPosition生效*/
	private DefSize rightWidth = DefSize.parse("200px");
	
	private ArrayList<MetaComponent> compList = new ArrayList<>();
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.SLIDINGLAYOUTPANEL;
	}
	
	/**
	 * 获取侧滑样式
	 * @return 侧滑样式，默认为抽屉式。其值为：Sliding-侧滑样式，Drawer-抽屉样式，Toggle-缩放侧滑样式
	 * <p>参考{@link SlidingType}</p>
	 */
	public Integer getStyle() {
		return style;
	}

	/**
	 * 设置侧滑样式
	 * @param style 侧滑样式，默认为抽屉式。其值为：Sliding-侧滑样式，Drawer-抽屉样式，Toggle-缩放侧滑样式
	 * <p>参考{@link SlidingType}</p>
	 */
	public void setStyle(Integer style) {
		this.style = style;
	}

	/**
	 * 获取侧滑组件所在方向，只存在主侧滑组件时有效。 当主次侧滑组件都存在时，该属性无效，主侧滑组件默认在左边，次侧滑组件默认在右边
	 * @return 侧滑组件所在方向
	 */
	public Integer getSlidingPosition() {
		return slidingPosition;
	}

	/**
	 * 设置侧滑组件所在方向，只存在主侧滑组件时有效。 当主次侧滑组件都存在时，该属性无效，主侧滑组件默认在左边，次侧滑组件默认在右边
	 * @param slidingPosition 侧滑组件所在方向
	 */
	public void setSlidingPosition(Integer slidingPosition) {
		this.slidingPosition = slidingPosition;
	}

	/**
	 * 获取左侧滑组件的宽度，根据slidingPosition生效
	 * @return 左侧滑组件的宽度
	 */
	public DefSize getLeftWidth() {
		return leftWidth;
	}

	/**
	 * 设置左侧滑组件的宽度，根据slidingPosition生效
	 * @param leftWidth 左侧滑组件的宽度
	 */
	public void setLeftWidth(DefSize leftWidth) {
		this.leftWidth = leftWidth;
	}

	/**
	 * 获取右侧滑组件的宽度，根据slidingPosition生效
	 * @return 右侧滑组件的宽度 
	 */
	public DefSize getRightWidth() {
		return rightWidth;
	}

	/**
	 * 设置右侧滑组件的宽度，根据slidingPosition生效
	 * @param rightWidth 右侧滑组件的宽度
	 */
	public void setRightWidth(DefSize rightWidth) {
		this.rightWidth = rightWidth;
	}
	
	/**
	 * 获取主显示组件
	 * @return 主显示组件
	 */
	public MetaComponent getMainComponent() {
		return mainComponent;
	}

	/**
	 * 设置主显示组件
	 * @param mainComponent 主显示组件
	 */
	public void setMainComponent(MetaComponent mainComponent) {
		this.mainComponent = mainComponent;
	}

	/**
	 * 获取主侧滑组件
	 * @return 主侧滑组件
	 */
	public MetaComponent getFirstComponent() {
		return firstComponent;
	}

	/**
	 * 设置主侧滑组件
	 * @param firstComponent 主侧滑组件
	 */
	public void setFirstComponent(MetaComponent firstComponent) {
		this.firstComponent = firstComponent;
	}

	/**
	 * 获取次侧滑组件
	 * @return 次侧滑组件
	 */
	public MetaComponent getSecondComponent() {
		return secondComponent;
	}

	/**
	 * 设置次侧滑组件
	 * @param secondComponent 次侧滑组件
	 */
	public void setSecondComponent(MetaComponent secondComponent) {
		this.secondComponent = secondComponent;
	}

	@Override
	public int getComponentCount() {
		return compList.size();
	}
	
	@Override
	public MetaComponent getComponent(int index) {
		if(index >= 0 && index < compList.size()){
			return compList.get(index);
		}
		return null;
	}
	
	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaSlidingLayoutPanel newObject = (MetaSlidingLayoutPanel)super.clone();
		newObject.setMainComponent(mainComponent == null ? null : (MetaComponent)mainComponent.clone());
		newObject.setFirstComponent(firstComponent == null ? null : (MetaComponent)firstComponent.clone());
		newObject.setSecondComponent(secondComponent == null ? null : (MetaComponent)secondComponent.clone());
		newObject.setStyle(style);
		newObject.setSlidingPosition(slidingPosition);
		newObject.setLeftWidth(leftWidth);
		newObject.setRightWidth(rightWidth);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSlidingLayoutPanel();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		if(mainComponent != null){
			list.add(mainComponent);
		}
		if(firstComponent != null){
			list.add(firstComponent);
		}
		if(secondComponent != null){
			list.add(secondComponent);
		}
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject metaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if(metaObject != null){
			return metaObject;
		}
		MetaComponentFactory factory = MetaComponentFactory.getInstance();
		MetaComponent metaComponent = factory.newComponent(tagName);
		if(metaComponent != null){
			if(mainComponent == null){
				mainComponent = metaComponent;
				mainComponent.preProcessMetaObject(env, doc, node, flag, runType);
				compList.add(mainComponent);
			} else if(firstComponent == null){
				firstComponent = metaComponent;
				firstComponent.preProcessMetaObject(env, doc, node, flag, runType);
				compList.add(firstComponent);
			} else if(secondComponent == null){
				secondComponent = metaComponent;
				secondComponent.preProcessMetaObject(env, doc, node, flag, runType);
				compList.add(secondComponent);
			}
		}
		return metaComponent;
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if(mainComponent == null){
			throw new MetaException(MetaException.MAIN_PANEL_NOT_DEFINED, String.format(
					StringTable.getString(null, "", StringTable.MainPanelNotDefined),getKey()));
		}else{
			mainComponent.doPostProcess(flag, callback);
		}
		if(firstComponent != null){
			firstComponent.doPostProcess(flag, callback);
		}
		if(secondComponent != null){
			secondComponent.doPostProcess(flag, callback);
		}
	}
}
