package com.bokesoft.yigo.meta.form.component.panel;

import java.util.Iterator;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLinearItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLinearLayout;
/**
 * Android独有<br>
 * 线性布局面板
 * @author ShiXuyun
 *
 */
public class MetaLinearLayoutPanel extends MetaPanel{
	public static final String TAG_NAME =ControlType.STR_LINEARLAYOUTPANEL;
	
	/**
	 * 布局方向
	 */
	private int orientation = OrientationType.Horizontal;
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.LINEARLAYOUTPANEL;
	}

	@Override
	public AbstractMetaObject getProperties() {		
		return null;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaLinearLayoutPanel newObj = (MetaLinearLayoutPanel) super.clone();
		newObj.setOrientation(orientation);
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO 自动生成的方法存根
		return  new MetaLinearLayoutPanel();
	}

	/** 
	 * 获取布局方向
	 * @return 布局方向
	 */
	public final int getOrientation() {
		return orientation;
	}

	/**
	 * 设置布局方向
	 * @param orientation 设置布局方向
	 */
	public final void setOrientation(int orientation) {
		this.orientation = orientation;
	}
	
	/**
	 * 从边界布局面板中生成边界布局
	 * @return 边界布局
	 */
	@Override
	public MetaLinearLayout newLayout() {
		MetaLinearLayout layout = new MetaLinearLayout();
		layout.setKey(key);
		layout.setOrientation(orientation);
		Iterator<MetaComponent> it = this.componentArray.iterator();
		MetaComponent metaComponent = null;
		while ( it.hasNext() ) {
			metaComponent = it.next();
			MetaLinearItem item = new MetaLinearItem();
			item.setKey(metaComponent.getKey());
			item.setHeight(metaComponent.getHeight());
			item.setWidth(metaComponent.getWidth());
			item.setWeight(metaComponent.getWeight());
			layout.add(item);
		}
		return layout;
	}
}