package com.bokesoft.yigo.meta.form.component.panel.FlexBoxPanel;

import java.util.Iterator;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFlexBox;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutFlowIndex;

public class MetaFlexBoxPanel extends MetaPanel {

	public static final String TAG_NAME = ControlType.STR_FLEXBOXPANEL;
	
	/** 几列布局 */
	private Integer repeatCount = 3;
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.FLEXBOXPANEL;
	}

	@Override
	public AbstractMetaObject getProperties() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFlexBoxPanel();
	}

	/**
	 * 获取布局列数
	 * @return
	 */
	public Integer getRepeatCount() {
		return repeatCount;
	}

	/**
	 * 设置布局列数
	 * @param repeatCount 布局列数
	 */
	public void setRepeatCount(Integer repeatCount) {
		this.repeatCount = repeatCount;
	}

	/**
	 * 从流布局面板中生成流布局
	 * @return 流布局
	 */
	public MetaFlexBox newLayout() {
		MetaFlexBox layout = new MetaFlexBox();
		layout.setKey(key);
		Iterator<MetaComponent> it = this.componentArray.iterator();
		MetaComponent metaComponent = null;
		while ( it.hasNext() ) {
			metaComponent = it.next();
			MetaLayoutFlowIndex item = new MetaLayoutFlowIndex();
			item.setKey(metaComponent.getKey());
			layout.add(item);
		}
		return layout;
	}
}
