package com.bokesoft.yigo.meta.form.component.i18n;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaI18nItem定义一个多语种项
 * <pre>
 * &lt;zh-CN&gt;中文&lt;/zh-CN&gt;
 * &lt;key&gt;value&lt;/key&gt;
 * </pre>
 * 语言节点
 * 
 */
public class MetaI18nItem extends AbstractMetaObject{
	/** 标志 */
	private String key = "";
	/** 值 */
	private String value = "";
	
	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key){
		this.key = key;
	}
	
	/**
	 * 取得标识
	 * @return 标识
	 */
	public String getKey(){
		return this.key;
	}
	
	/**
	 * 取得值
	 * @return 值
	 */
	public String getValue() {
		return value;
	}

	/**
	 * 设置值
	 * @param value 值
	 */
	public void setValue(String value) {
		this.value = value;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {

	}

	public static final String TAG_NAME = "I18nItem";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaI18nItem newObject = new MetaI18nItem();
		newObject.setKey(key);
		newObject.setValue(value);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaI18nItem();
	}

}
