package com.bokesoft.yigo.meta.form.component.grid;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.common.def.RowExpandType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

/**
 * 行扩展元数据对象
 * @author 陈瑞
 *
 */
public class MetaRowExpand extends MetaBaseScript {
	/**　扩展类型 */
	private Integer expandType = RowExpandType.DICT;
	/** 单元格标识,字典拓展使用 */
	private String cellKey = "";
	
	public static final String TAG_NAME = "RowExpand";
	
	public MetaRowExpand() {
		super(TAG_NAME);
	}

	/**
	 * 取得行扩展类型
	 * @return 行扩展类型
	 */
	public Integer getExpandType() {
		return expandType;
	}

	/**
	 * 设置行扩展类型
	 * @param expandType 行扩展类型
	 */
	public void setExpandType(Integer expandType) {
		this.expandType = expandType;
	}

	/**
	 * 获取单元格标识
	 * @return
	 */
	public String getCellKey() {
		return cellKey;
	}

	/**
	 * 设置单元格标识
	 * @param cellKey
	 */
	public void setCellKey(String cellKey) {
		this.cellKey = cellKey;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaRowExpand newObject = (MetaRowExpand)super.clone();
		newObject.setExpandType(expandType);
		newObject.setCellKey(cellKey);
		
		return newObject;
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRowExpand();
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		
		return null;
	}

}
