package com.bokesoft.yigo.meta.form.component.grid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaGridRowGroup表示一个表格行元数据的分组，包含多个行或分组，该对象为表格元数据载入后计算出的元数据
 * 
 * @author 王元和
 */
public class MetaGridRowGroup extends AbstractMetaObject implements
		IMetaGridRowObject {
	/** 行对象集合 */
	private ArrayList<IMetaGridRowObject> objectArray = null;
	/** 顶行 */
	private int topRow = -1;
	/** 底行 */
	private int bottomRow = -1;
	/** 分组的标识 */
	private String groupKey = null;
	/** 是否叶子分组标志 */
	private boolean leaf = false;
	/** 分组头数量*/
	private int headCount = 0;
	/** 分组尾数量*/
	private int tailCount = 0;

	public MetaGridRowGroup(String groupKey) {
		super();
		this.groupKey = groupKey;
		objectArray = new ArrayList<IMetaGridRowObject>();
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "RowGroup";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public int getObjectType() {
		return IMetaGridRowObject.Group;
	}
	/**
	 * 获取分组标识
	 * 
	 * @return 分组标识
	 */
	public String getGroupKey() {
		return groupKey;
	}

	/**
	 * 设置分组标识
	 * 
	 * @param groupKey 分组标识
	 */
	public void setGroupKey(String groupKey) {
		this.groupKey = groupKey;
	}

	/**
	 * 增加行对象
	 * 
	 * @param row
	 *            行对象，可以是普通行或分组
	 * @see MetaGridRow
	 * @see MetaGridRowGroup
	 */
	public void addObject(IMetaGridRowObject row) {
		this.objectArray.add(row);
	}
	
	/**
	 * 添加行
	 * @param metaRow
	 */
	public void addRow(MetaGridRow metaRow) {
		if( metaRow.isGroupHead() ) {
			this.objectArray.add(headCount++, metaRow);
		} else {
			this.objectArray.add(metaRow);
		}
	}

	/**
	 * 取得行对象的数量
	 * 
	 * @return 行对象数量
	 */
	public int getObjectCount() {
		return objectArray.size();
	}

	/**
	 * 根据位置取得行对象
	 * 
	 * @param index
	 *            位置
	 * @return 所在位置的行对象
	 */
	public IMetaGridRowObject getObject(int index) {
		return objectArray.get(index);
	}
	
	public boolean contains(IMetaGridRowObject obj) {
		return this.objectArray.contains(obj);
	}

	public void remove(int index) {
		this.objectArray.remove(index);
	}

	public void addObject(int index, IMetaGridRowObject obj) {
		this.objectArray.add(index, obj);
	}

	public void setObject(int index, IMetaGridRowObject row) {
		objectArray.set(index, row);
	}

	public Iterator<IMetaGridRowObject> iterator() {
		return objectArray.iterator();
	}

	public void setTopRow(int topRow) {
		this.topRow = topRow;
	}

	public int getTopRow() {
		return this.topRow;
	}

	public void setBottomRow(int bottomRow) {
		this.bottomRow = bottomRow;
	}

	public int getBottomRow() {
		return this.bottomRow;
	}

	public boolean isInRange(int index) {
		return index >= topRow && index <= bottomRow;
	}

	@Override
	public void printDebugInfo(int level) {
		LogSvr.getInstance().info("group" + "\t" + level + "");
		Iterator<IMetaGridRowObject> it = objectArray.iterator();
		IMetaGridRowObject rowObject = null;
		while (it.hasNext()) {
			rowObject = it.next();
			rowObject.printDebugInfo(level + 1);
		}
	}

	@Override
	public AbstractMetaObject clone() {
		MetaGridRowGroup rowGroup = (MetaGridRowGroup) this.newInstance();
		Iterator<IMetaGridRowObject> it = objectArray.iterator();
		AbstractMetaObject obj = null;
		while( it.hasNext() ){
			obj = (AbstractMetaObject) it.next();
			rowGroup.addObject((IMetaGridRowObject) obj.clone());
		}
		return rowGroup;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGridRowGroup(groupKey);
	}

	@Override
	public void getAll(int objectType, ArrayList<IMetaGridRowObject> list) {
		Iterator<IMetaGridRowObject> it = objectArray.iterator();
		IMetaGridRowObject rowObject = null;
		while (it.hasNext()) {
			rowObject = it.next();
			if (rowObject.getObjectType() == objectType) {
				list.add(rowObject);
			}
			rowObject.getAll(objectType, list);
		}
	}
}
