package com.bokesoft.yigo.meta.form.component.grid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaGridColumnLayer表示列层次，派生对象。由列对象和区域组成，结构如下：
 *+-----------------+-------------------------------------------------+
 *| Fix             |                      Area                       |
 *+-----------------+-----------------+---------------+---------------+
 *|                 |     Group       |     Detail    |    Group      |
 *+-----------------+-----------------+---------------+---------------+
 *|                 |                 |               |               |
 *+-----------------+-----------------+---------------+---------------+
 * @author 王元和
 *
 */
public class MetaGridColumnLayer extends AbstractMetaObject {
	private ArrayList<IMetaGridColumnObject> objectArray = null;
	private boolean hasColumnExpand = false;
	public MetaGridColumnLayer() {
		super();
		objectArray = new ArrayList<IMetaGridColumnObject>();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "ColumnLayer";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	public void addObject(IMetaGridColumnObject column) {
		this.objectArray.add(column);
		if ( column.getObjectType() == IMetaGridColumnObject.Area ) {
			hasColumnExpand = true;
		}
	}
	
	public int getObjectCount() {
		return objectArray.size();
	}
	
	public IMetaGridColumnObject getObject(int index) {
		return objectArray.get(index);
	}
	
	public boolean hasColumnExpand() {
		return this.hasColumnExpand;
	}
	
	public void printDebugInfo() {
		Iterator<IMetaGridColumnObject> it = objectArray.iterator();
		IMetaGridColumnObject column = null;
		while ( it.hasNext() ) {
			column = it.next();
			column.printDebugInfo(0);
		}
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return null;
	}
	
	public void getAll(int objectType, ArrayList<IMetaGridColumnObject> list) {
		Iterator<IMetaGridColumnObject> it = objectArray.iterator();
		IMetaGridColumnObject column = null;
		while ( it.hasNext() ) {
			column = it.next();
			if ( column.getObjectType() == objectType ) {
				list.add(column);
			}
			column.getAll(objectType, list);
		}
	}
}
