package com.bokesoft.yigo.meta.form.component.grid;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import com.bokesoft.yigo.common.def.ColumnExpandType;
import com.bokesoft.yigo.common.def.ExpandSourceType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

/**
 * 列拓展元数据对象，从MetaBaseScript派生
 * 
 * @author 陈瑞
 *
 */
public class MetaColumnExpand extends MetaBaseScript {

	/** 列拓展的类型，见{@link com.bokesoft.yigo.common.def.ColumnExpandType} */
	private Integer expandType = ColumnExpandType.DATA;
	
	/**列拓展的数据源类型，见{@link com.bokesoft.yigo.common.def.ExpandSourceType}*/
	private Integer expandSourceType = ExpandSourceType.CUSTOM;
	
	/** 列拓展数据表标识*/
	private String tableKey = "";
	
	/** 列拓展数据列标识*/
	private String columnKey = "";
	
	/** 列拓展来源于数据且是字典类型作值转换*/
	private String itemKey = "";
	
	/** 拓展依赖*/
	private String expandDependency = "";
	
	/** 过滤条件所依赖的字段*/
	private List<String> dependentFields = null;
	
	/**
	 * 获取拓展数据源类型
	 * @return expandSourceType
	 */
	public Integer getExpandSourceType() {
		return expandSourceType;
	}
	
	/**
	 * 设置拓展数据源类型
	 * @param expandSourceType 扩展数据源类型
	 */
	public void setExpandSourceType(Integer expandSourceType) {
		this.expandSourceType = expandSourceType;
	}
	
	/**
	 * 获取列扩展依赖
	 * @return 列扩展依赖
	 */
	public String getExpandDependency() {
		return expandDependency;
	}

	/**
	 * 设置列扩展依赖
	 * @param expandDependency 列扩展依赖
	 */
	public void setExpandDependency(String expandDependency) {
		this.expandDependency = expandDependency;
		
		if(expandDependency != null && expandDependency.length() > 0){
			if( this.dependentFields == null ) {
				this.dependentFields = new ArrayList<String>();
			}
			String[] fields = this.expandDependency.split(",");
			for(String field : fields){
				dependentFields.add(field);
			}
		}
	}

	/**
	 * 获取列扩展依赖的字段集合
	 * @return 列扩展依赖的字段集合
	 */
	public List<String> getDependentFields() {
		return dependentFields;
	}

	/**
	 * 获取字典标识
	 * @return 字典标识
	 */
	public String getItemKey() {
		return itemKey;
	}

	/**
	 * 设置字典标识
	 * @param itemKey 字典标识
	 */
	public void setItemKey(String itemKey) {
		this.itemKey = itemKey;
	}

	public MetaColumnExpand() {
		super(TAG_NAME);
	}
	
	public static final String TAG_NAME = "ColumnExpand";
	
	/**
	 * 列扩展类型
	 * 
	 * @return 列扩展类型
	 */
	public Integer getExpandType() {
		return expandType;
	}

	/**
	 * 设置列扩展类型
	 * 
	 * @param expandType 列扩展类型
	 */
	public void setExpandType(Integer expandType) {
		this.expandType = expandType;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 列拓展数据表标识
	 * @return 表标识
	 */
	public String getTableKey() {
		return tableKey;
	}

	/**
	 * 列拓展数据列标识
	 * @param tableKey 表标识
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}

	/**
	 * 取得列标识
	 * @return 列标识
	 */
	public String getColumnKey() {
		return columnKey;
	}

	/**
	 * 设置列标识
	 * @param columnKey 列标识
	 */
	public void setColumnKey(String columnKey) {
		this.columnKey = columnKey;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaColumnExpand columnExpand = (MetaColumnExpand)super.clone();
		columnExpand.setExpandSourceType(expandSourceType);
		columnExpand.setExpandType(expandType);
		columnExpand.setTableKey(tableKey);
		columnExpand.setColumnKey(columnKey);
		columnExpand.setItemKey(itemKey);
		return columnExpand;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaColumnExpand();
	}

}