package com.bokesoft.yigo.meta.form.component.grid;

import java.util.ArrayList;

/**
 * IMetaGridRowObject定义表格行元数据的接口，用于在生成表格元数据行的层次结构时用于表示复合结构
 * @author 王元和
 */
public interface IMetaGridRowObject {
	/** 行对象 */
	public static final int Row = 0;
	/** 行分组对象 */
	public static final int Group = 1;
	/** 区域对象 */
	public static final int Area = 2;
	
	/**
	 * 返回行对象的类型，包括行、行分组和区域
	 * @return 对象的类型，根据派生类而定
	 */
	public int getObjectType();
	
	/**
	 * 取得子对象数量
	 * @return 数量
	 */
	public int getObjectCount();
	
	/**
	 * 根据序号取得子对象
	 * @param index 序号
	 * @return index所在位置的子对象
	 */
	public IMetaGridRowObject getObject(int index);
	
	public void printDebugInfo(int level);
	
	/**
	 * 根据类型取得所有的子对象(包括子对象的子对象)
	 * @param objectType 对象类型
	 * @param list 结果列表
	 */
	public void getAll(int objectType, ArrayList<IMetaGridRowObject> list);
}
