package com.bokesoft.yigo.meta.form.component.control.wizardlist;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;	

public class MetaWizardItem extends KeyPairMetaObject {
	public static final String TAG_NAME = "WizardItem";

	/** 唯一标识*/
	private String key = "";
	/** 层次界面导航项的显示字段标识 */
	private String captionFieldKey = "";
	/** 层次选中时需要获取值的字段标识，作为回填来源 */
	private String valueFieldKey = "";

	@Override
	public String getKey() {
		return key;
	}
	
	@Override
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 获取层次界面导航项的显示字段标识
	 * @return 层次界面导航项的显示字段标识
	 */
	public String getCaptionFieldKey() {
		return captionFieldKey;
	}

	/**
	 * 设置层次界面导航项的显示字段标识
	 * @param captionFieldKey 层次界面导航项的显示字段标识
	 */
	public void setCaptionFieldKey(String captionFieldKey) {
		this.captionFieldKey = captionFieldKey;
	}

	/**
	 * 获取层次选中时需要获取值的字段标识
	 * @return 层次选中时需要获取值的字段标识
	 */
	public String getValueFieldKey() {
		return valueFieldKey;
	}

	/**
	 * 设置层次选中时需要获取值的字段标识
	 * @param valueFieldKey 层次选中时需要获取值的字段标识
	 */
	public void setValueFieldKey(String valueFieldKey) {
		this.valueFieldKey = valueFieldKey;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaWizardItem item = new MetaWizardItem();
		item.setKey(key);
		item.setCaptionFieldKey(captionFieldKey);
		item.setValueFieldKey(valueFieldKey);
		return item;
	}


	@Override
	public AbstractMetaObject newInstance() {
		return new MetaWizardItem();
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}
}
