package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ImageSourceType;
import com.bokesoft.yigo.common.def.UploadProgressType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaVideoPlayerProperties extends AbstractMetaObject
		implements IPropertyMerger<MetaVideoPlayerProperties> {
	/** 视频来源类型，取值为Data或Resource，默认值为Data,-1代表未定义 */
	private Integer sourceType = ImageSourceType.DATA;

	/** 在SourceType为Resource时，定义视频来源 */
	private String path = "";

	/** 显示上传进度指示器的样式,有None、Strip、Circle、Percent，分别是 不显示、条状、圆环状、百分比。默认不显示 */
	private Integer uploadProgress = UploadProgressType.NONE;

	/**
	 * 获取是否显示上传进度指示器
	 *
	 * @return 是否显示上传进度指示器
	 */
	public Integer getUploadProgress() {
		return uploadProgress;
	}

	/**
	 * 设置是否显示上传进度指示器
	 *
	 * @param uploadProgress
	 *            是否显示上传进度指示器
	 */
	public void setUploadProgress(Integer uploadProgress) {
		this.uploadProgress = uploadProgress;
	}

	/**
	 * 设置视频来源类型，取值为Data或Resource，默认值为Data
	 * 
	 * @param type
	 *            视频来源类型，取值为Data或Resource
	 */
	public void setSourceType(Integer type) {
		this.sourceType = type;
	}

	/**
	 * 获取视频来源类型，取值为Data或Resource，默认值为Data
	 * 
	 * @return 视频来源类型，取值为Data或Resource
	 */
	public Integer getSourceType() {
		return this.sourceType;
	}

	/**
	 * 在SourceType为Resource时，设置视频来源
	 * 
	 * @param path
	 *            视频来源
	 */
	public void setPath(String path) {
		this.path = path;
	}

	/**
	 * 获取视频来源
	 * 
	 * @return 视频来源
	 */
	public String getPath() {
		return this.path;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] {});
	}

	@Override
	public String getTagName() {
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		return null;
	}

	@Override
	public MetaVideoPlayerProperties clone() {
		MetaVideoPlayerProperties newObject = newInstance();
		newObject.setSourceType(sourceType);
		newObject.setPath(path);
		newObject.setUploadProgress(uploadProgress);
		return newObject;
	}

	@Override
	public MetaVideoPlayerProperties newInstance() {
		return new MetaVideoPlayerProperties();
	}

	@Override
	public void merge(MetaVideoPlayerProperties properties) {
		if (this.sourceType == -1) {
			this.sourceType = properties.getSourceType();
		}
		if (this.path == null) {
			this.path = properties.getPath();
		}
	}
}
