package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.SelectEditType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaMonthPickerProperties extends AbstractMetaObject implements IPropertyMerger<MetaMonthPickerProperties> {
    /**
     * 日期时间的显示格式
     */
    private String dateFormat = null;

    /**
     * 文本编辑器为空时的提示信息
     */
    private String promptText = "";

    /**
     * 编辑样式
     */
    private Integer editType = SelectEditType.POP;

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDateFormat() {
        return dateFormat;
    }

    public void setPromptText(String promptText) {
        this.promptText = promptText;
    }

    public Integer getEditType() {
        return editType;
    }

    public void setEditType(Integer editType) {
        this.editType = editType;
    }

    public String getPromptText() {
        return promptText;
    }


    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {

    }

    @Override
    public String getTagName() {
        return null;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
                                                    int runType) throws MetaException {
        return null;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaMonthPickerProperties newObject = new MetaMonthPickerProperties();
        newObject.setDateFormat(dateFormat);
        newObject.setPromptText(promptText);
        newObject.setEditType(editType);
        return newObject;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaMonthPickerProperties();
    }


    @Override
    public void merge(MetaMonthPickerProperties properties) {
        if (this.dateFormat == null) {
            this.dateFormat = properties.getDateFormat();
        }
        if (this.promptText == null) {
            this.promptText = properties.getPromptText();
        }
    }
}
