package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ImageSourceType;
import com.bokesoft.yigo.common.def.ImageViewMode;
import com.bokesoft.yigo.common.def.UploadProgressType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaImageProperties extends AbstractMetaObject implements IPropertyMerger<MetaImageProperties>{
	/** 图片来源类型，取值为Data或Resource，默认值为Data,-1代表未定义 */
	private int sourceType = ImageSourceType.DATA;

	/** 在SourceType为Resource时，定义图片来源 */
	private String image = "";
	
	/** 鼠标点击事件 */
	private MetaBaseScript onClick = null;
	
	/** 是否拉伸 */
	private Boolean stretch = false;
	
	/**拉伸缩放类型,目前移动端使用*/
	private Integer imageScaleType = -1;
	
	/** 上传文件大小,-1表示无限制*/
	private Integer maxSize = -1;
	
	/** 是否剪切 */
	private Boolean imageCut = false;
	
	/** 没有值时显示的提示图片*/
	private String promptImage = "";
	
	/** 圆角半径，主要用于显示头像时的外框圆角*/
	private Integer radius = -1;
	
	/** 图片固定名称，上传时如果该值不为空，则上传的图片固定为该名称*/
	private String fileName = "";
	
	/** 图片查看模式，默认为图片组件本身*/
	private Integer viewMode = ImageViewMode.SELF;
	
	/** 图片是否允许操作，比如旋转，缩放等*/
	private Boolean viewOpt = false;
	
	/** 图片形状遮罩模板，一般用于制作头像*/
	private String maskImage = "";
	
	/** ShowThumbnail：是否显示缩略图,如果是true，则会先从所给图片路径下的同级目录的temp文件夹中拿同样的文件名的图片，
	 * 例如：图片路径为 UIDemo/1.jpg，缩略图路径则是UIDemo/temp/1.jpg。如果找不到缩略图，则直接取原图;如果是false，则取原图默认值为true*/
	private Boolean showThumbnail=true;

	/** 显示上传进度指示器的样式,有None、Strip、Circle、Percent，分别是 不显示、条状、圆环状、百分比。默认不显示*/
	private Integer uploadProgress = UploadProgressType.NONE;
	
	/** 图片加载到内存中大小的最大值，单位KB */
	private Integer maxShowSize = 10000;

	/**
	 * 获取是否显示上传进度指示器
	 *
	 * @return 是否显示上传进度指示器
	 */
	public Integer getUploadProgress() {
		return uploadProgress;
	}
	/**
	 * 设置是否显示上传进度指示器
	 *
	 * @param uploadProgress 是否显示上传进度指示器
	 */
	public void setUploadProgress(Integer uploadProgress) {
		this.uploadProgress = uploadProgress;
	}



	/**
	 * 获取是否显示缩略图,
	 *
	 * @return 是否显示缩略图
	 */
	public Boolean isShowThumbnail() {
		return showThumbnail;
	}

	/**
	 * 设置是否显示缩略图
	 *
	 * @param showThumbnail 是否显示缩略图
	 */
	public void setShowThumbnail(Boolean showThumbnail) {
		this.showThumbnail = showThumbnail;
	}


	/**
	 * 设置图片来源类型，取值为Data或Resource，默认值为Data
	 * 
	 * @param type
	 *            图片来源类型，取值为Data或Resource
	 */
	public void setSourceType(int type) {
		this.sourceType = type;
	}

	/**
	 * 获取图片来源类型，取值为Data或Resource，默认值为Data
	 * 
	 * @return 图片来源类型，取值为Data或Resource
	 */
	public int getSourceType() {
		return this.sourceType;
	}

	/**
	 * 在SourceType为Resource时，设置图片来源
	 * 
	 * @param image
	 *            图片来源
	 */
	public void setImage(String image) {
		this.image = image;
	}

	/**
	 * 获取图片来源
	 * 
	 * @return 图片来源
	 */
	public String getImage() {
		return this.image;
	}
	
	/**
	 * 设置鼠标点击事件
	 * @param onClick 点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		this.onClick = onClick;
	}
	
	/**
	 * 取得鼠标点击事件
	 * @return 点击事件
	 */
	public MetaBaseScript getOnClick() {
		return onClick;
	}
	
	
	/**
	 * 获取限定文件上传大小的最大值
	 * @return 文件大小的最大值
	 */
	public Integer getMaxSize() {
		return maxSize;
	}

	/**
	 * 限定文件上传大小
	 * @param maxSize  文件大小
	 */
	public void setMaxSize(Integer maxSize) {
		this.maxSize = maxSize;
	}
	
	public Integer getImageScaleType() {
		return imageScaleType;
	}

	public void setImageScaleType(Integer imageScaleType) {
		this.imageScaleType = imageScaleType;
	}

	/**
	 * 获取是否剪切
	 * @return 是否剪切标志
	 */
	public Boolean isImageCut() {
		return imageCut;
	}

	/**
	 * 设置图片是否做剪切操作
	 * @param imageCut 剪切标志
	 */
	public void setImageCut(Boolean imageCut) {
		this.imageCut = imageCut;
	}

	/**
	 * 获取没有值时的提示图片
	 * @return 没有值时的提示图片
	 */
	public String getPromptImage() {
		return promptImage;
	}

	/**
	 * 设置没有值时的提示图片
	 * @param promptImage 没有值时的提示图片
	 */
	public void setPromptImage(String promptImage) {
		this.promptImage = promptImage;
	}

	/**
	 * 获取图片圆角半径
	 * @return 图片圆角半径
	 */
	public Integer getRadius() {
		return radius;
	}

	/**
	 * 设置图片圆角半径
	 * @param radius 图片圆角半径
	 */
	public void setRadius(Integer radius) {
		this.radius = radius;
	}

	/**
	 * 获取图片固定文件名，上传时如果该值不为空，则上传使用该文件名
	 * @return 图片固定文件名
	 */
	public String getFileName() {
		return fileName;
	}

	/**
	 * 设置图片固定文件名，上传时如果该值不为空，则上传使用该文件名
	 * @param fileName 图片固定文件名
	 */
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	/**
	 * 获取图片查看模式
	 * @return 图片查看模式
	 */
	public Integer getViewMode() {
		return viewMode;
	}

	/**
	 * 设置图片查看模式
	 * @param viewMode 图片查看模式
	 */
	public void setViewMode(Integer viewMode) {
		this.viewMode = viewMode;
	}

	/**
	 * 获取图片是否允许查看操作，比如缩放、旋转等等
	 * @return 是否允许查看操作
	 */
	public Boolean isViewOpt() {
		return viewOpt;
	}

	/**
	 * 设置图片是否允许查看操作，比如缩放、旋转等等
	 * @param viewOpt 是否允许查看操作
	 */
	public void setViewOpt(Boolean viewOpt) {
		this.viewOpt = viewOpt;
	}

	/**
	 * 获取图片形状截取模板，一般用于制作头像
	 * @return 模板来源
	 */
	public String getMaskImage() {
		return maskImage;
	}
	/**
	 * 设置图片形状截取模板，一般用于制作头像
	 * @param maskImage 模板来源
	 */
	public void setMaskImage(String maskImage) {
		this.maskImage = maskImage;
	}
	/**
	 * 设置是否拉伸
	 * @param stretch 是否拉伸标志
	 */
	public void setStretch(Boolean stretch) {
		this.stretch = stretch;
	}

	/**
	 * 取得是否拉伸
	 * @return 是否拉伸标志
	 */
	public Boolean isStretch() {
		return this.stretch;
	}

	/**
	/**
	 * 获取图片加载到内存中大小的最大值，单位KB
	 * @return 图片加载到内存中大小的最大值
	 */
	public Integer getMaxShowSize() {
		return maxShowSize;
	}
	
	/**
	 * 设置图片加载到内存中大小的最大值，单位KB
	 * @param maxShowSize 图片加载到内存中大小的最大值
	 */
	public void setMaxShowSize(Integer maxShowSize) {
		this.maxShowSize = maxShowSize;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { onClick });
	}

	@Override
	public String getTagName() {
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaConstants.Event_OnClick.equals(tagName) ) {
			onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
			resultMetaObject = onClick;
		}

		return resultMetaObject;
	}

	@Override
	public MetaImageProperties clone() {
		MetaImageProperties newObject = newInstance();
		newObject.setSourceType(sourceType);
		newObject.setImage(image);
		newObject.setStretch(stretch);
		newObject.setImageScaleType(imageScaleType);
		newObject.setOnClick(onClick == null ? null : (MetaBaseScript)onClick.clone());
		newObject.setMaxSize(maxSize);
		newObject.setImageCut(imageCut);
		newObject.setPromptImage(promptImage);
		newObject.setRadius(radius);
		newObject.setFileName(fileName);
		newObject.setViewMode(viewMode);
		newObject.setViewOpt(viewOpt);
		newObject.setMaskImage(maskImage);
		newObject.setShowThumbnail(showThumbnail);
		newObject.setUploadProgress(uploadProgress);
		newObject.setMaxShowSize(maxShowSize);
		return newObject;
	}

	@Override
	public MetaImageProperties newInstance() {
		return new MetaImageProperties();
	}


	@Override
	public void merge(MetaImageProperties properties) {
		if( this.sourceType == -1 ) {
			this.sourceType = properties.getSourceType();
		}
		if( this.image == null ) {
			this.image = properties.getImage();
		}
		if( this.onClick == null ) {
			this.onClick = properties.getOnClick();
		}
		if( this.stretch == null ) {
			this.stretch = properties.isStretch();
		}
		if( this.maxSize == null ) {
			this.maxSize = properties.getMaxSize();
		}
		if( this.imageCut == null ) {
			this.imageCut = properties.isImageCut();
		}
		if( this.maxShowSize == null){
			this.maxShowSize = properties.getMaxShowSize();
		}
	}
}
