package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.BarCodeType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaBarCoderProperties extends AbstractMetaObject implements IPropertyMerger<MetaBarCoderProperties> {

	/** 条码类型 */
	private Integer codeType = BarCodeType.QR_CODE;

	public MetaBarCoderProperties() {
	}

	/**
	 * 设置条码类型
	 * 
	 * @param codeType
	 *            条码类型，值为{@link BarCodeType}
	 */
	public void setCodeType(Integer codeType) {
		this.codeType = codeType;
	}

	/**
	 * 获取条码类型
	 * 
	 * @return 条码类型
	 */
	public Integer getCodeType() {
		return codeType;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaBarCoderProperties newObject = (MetaBarCoderProperties) newInstance();
		newObject.setCodeType(codeType);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBarCoderProperties();
	}

	@Override
	public void merge(MetaBarCoderProperties properties) {
		if (this.codeType == -1) {
			this.codeType = properties.getCodeType();
		}
	}
}
