package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaAttachmentProperties extends AbstractMetaObject implements IPropertyMerger<MetaAttachmentProperties>{
	/** 实现类 */
	private String impl = "";
	/** 关联的数据表的标识*/
	private String tableKey = "";
	/** 上传服务的实现类标识*/
	private String provider = "";
	/** 上传文件的大小,-1表示无限制 */
	private Integer maxSize = -1;
	/** 允许的类型*/
	private String allowedTypes ="";
	/** 是否可预览 */
	private Boolean preview = false;
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}
	
	/**
	 * 设置实现类
	 * @param impl 实现类
	 */
	public void setImpl(String impl) {
		this.impl = impl;
	}
	
	/**
	 * 取得实现类
	 * @return 实现类
	 */
	public String getImpl() {
		return this.impl;
	}
	
	public String getProvider() {
		return provider;
	}

	public void setProvider(String provider) {
		this.provider = provider;
	}

	public String getTableKey() {
		return tableKey;
	}

	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}

	public Integer getMaxSize() {
		return maxSize;
	}

	public void setMaxSize(Integer maxSize) {
		this.maxSize = maxSize;
	}

	public String getAllowedTypes() {
		return allowedTypes;
	}

	public void setAllowedTypes(String allowedTypes) {
		this.allowedTypes = allowedTypes;
	}

	public Boolean isPreview() {
		return this.preview;
	}

	public void setPreview(Boolean preview) {
		this.preview = preview;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaAttachmentProperties newObject = new MetaAttachmentProperties();
		newObject.setImpl(impl);
		newObject.setTableKey(tableKey);
		newObject.setMaxSize(maxSize);
		newObject.setProvider(provider);
		newObject.setPreview(preview);
		newObject.setAllowedTypes(allowedTypes);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaAttachmentProperties();
	}

	@Override
	public void merge(MetaAttachmentProperties properties) {
		if( this.impl == null ) {
			this.impl = properties.getImpl();
		}
		if( this.tableKey == null ) {
			this.tableKey = properties.getTableKey();
		}
		if( this.provider == null ) {
			this.tableKey = properties.getTableKey();
		}
		if( this.maxSize == null ) {
			this.maxSize = properties.getMaxSize();
		}
		if( this.allowedTypes == null ) {
			this.allowedTypes = properties.getAllowedTypes();
		}
		if( this.preview == null ) {
			this.preview = properties.isPreview();
		}
	}

}
