package com.bokesoft.yigo.meta.form.component.control.listview;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;

public class MetaTiledList extends MetaEditView {
	public static final String TAG_NAME = ControlType.STR_TILEDLIST;
	public static final int TILEDLIST_DEFAULT_COUNT = 3;
	/** 单行列数 */
	private Integer count = TILEDLIST_DEFAULT_COUNT;
	/** 行间隔 */
	private Integer rowGap = 0;
	/** 单元格间隔 */
	private Integer cellGap = 0;
	
	/**
	 * 设置行间隔
	 * @param rowGap 行间隔
	 */
	public void setRowGap(Integer rowGap) {
		this.rowGap = rowGap;
	}
	
	/**
	 * 获取行间隔
	 * @return 行间隔
	 */
	public Integer getRowGap() {
		return rowGap;
	}
	
	/**
	 * 设置单元格间隔
	 * @param cellGap 单元格间隔
	 */
	public void setCellGap(Integer cellGap) {
		this.cellGap = cellGap;
	}
	
	/**
	 * 获取单元格间隔
	 * @return 单元格间隔
	 */
	public Integer getCellGap() {
		return cellGap;
	}
	
	/**
	 * 设置单行列数 
	 * @param count 单行列数 
	 */
	public void setCount(Integer count) {
		this.count = count;
	}
	
	/**
	 * 取得单行列数 
	 * @return 单行列数 
	 */
	public Integer getCount() {
		return this.count;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.TILEDLIST;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTiledList newObject = (MetaTiledList)super.clone();
		newObject.setCount(count);
		newObject.setRowGap(rowGap);
		newObject.setCellGap(cellGap);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTiledList();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
	
	@Override
	public int getDefaultOrientation() {
		return OrientationType.Vertical;
	}
}
