package com.bokesoft.yigo.meta.form.component.control.listview;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;

public class MetaRotatorList extends MetaEditView {
	public static final String TAG_NAME = ControlType.STR_ROTATORLIST;
	
	public static final int ROTATORLIST_DEFAULT_ROWCOUNT = 3;
	public static final int ROTATORLIST_DEFAULT_COLUMNCOUNT = 3;
	
	/** 末尾追加单元的执行事件*/
	private MetaMoreItem moreItem = null;
	/** 行间隔*/
	private Integer rowGap = 0;
	/** 单元格间隔*/
	private Integer cellGap = 0;
	/** 排布行数*/
	private Integer rowCount = ROTATORLIST_DEFAULT_ROWCOUNT;
	/** 排布列数*/
	private Integer columnCount = ROTATORLIST_DEFAULT_COLUMNCOUNT;
	/** 是否显示指示器*/
	private Boolean indicator = true;
	/** 是否显示页码*/
	private Boolean pagination = false;
	/** 指示器位置*/
	private Integer indicatorLocation = -1;
	
	/**
	 * 设置是否显示指示器
	 * @param indicator 是否显示指示器
	 */
	public void setIndicator(Boolean indicator) {
		this.indicator = indicator;
	}
	
	/**
	 * 是否显示指示器
	 * @return 是否显示指示器
	 */
	public Boolean isIndicator() {
		return indicator;
	}
	
	/**
	 * 设置是否显示页码
	 * @param pagination 是否显示页码
	 */
	public void setPagination(Boolean pagination) {
		this.pagination = pagination;
	}
	
	/**
	 * 是否显示页码
	 * @return 是否显示页码
	 */
	public Boolean isPagination() {
		return pagination;
	}
	
	/**
	 * 设置指示器位置
	 * @param indicatorLocation 指示器位置，参考{@link com.bokesoft.yigo.common.def.HAlignment}
	 */
	public void setIndicatorLocation(Integer indicatorLocation) {
		this.indicatorLocation = indicatorLocation;
	}
	
	/**
	 * 获取指示器位置
	 * @return 指示器位置，参考{@link com.bokesoft.yigo.common.def.HAlignment}
	 */
	public Integer getIndicatorLocation() {
		return indicatorLocation;
	}
	
	/**
	 * 设置末尾追加单元的执行事件
	 * @param moreItem 末尾追加单元的执行事件
	 */
	public void setMoreItem(MetaMoreItem moreItem){
		this.moreItem = moreItem;
	}
	
	/**
	 * 获取末尾追加单元的执行事件
	 * @return 末尾追加单元的执行事件
	 */
	public MetaMoreItem getMoreItem(){
		return this.moreItem;
	}
	/**
	 * 设置行间隔
	 * @param rowGap 行间隔
	 */
	public void setRowGap(Integer rowGap) {
		this.rowGap = rowGap;
	}
	
	/**
	 * 获取行间隔
	 * @return 行间隔
	 */
	public Integer getRowGap() {
		return rowGap;
	}
	
	/**
	 * 设置单元格间隔
	 * @param cellGap 单元格间隔
	 */
	public void setCellGap(Integer cellGap) {
		this.cellGap = cellGap;
	}
	
	/**
	 * 获取单元格间隔
	 * @return 单元格间隔
	 */
	public Integer getCellGap() {
		return cellGap;
	}
	
	/**
	 * 设置排布行数
	 * @param rowCount 排布行数
	 */
	public void setRowCount(Integer rowCount) {
		this.rowCount = rowCount;
	}
	
	
	/**
	 * 获取排布行数
	 * @return 排布行数
	 */
	public Integer getRowCount() {
		return rowCount;
	}
	
	
	/**
	 * 设置排布列数
	 * @param columnCount 排布列数
	 */
	public void setColumnCount(Integer columnCount) {
		this.columnCount = columnCount;
	}
	
	/**
	 * 获取排布列数
	 * @return 排布列数
	 */
	public Integer getColumnCount() {
		return columnCount;
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.ROTATORLIST;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new AbstractMetaObject[] {  moreItem });
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if( MetaConstants.RotatorList_MoreItem.equalsIgnoreCase(tagName)){
			moreItem = new MetaMoreItem();
			resultMetaObject = moreItem;
		} 
		if ( resultMetaObject == null ) {
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		return resultMetaObject;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaRotatorList newObject = (MetaRotatorList)super.clone();
		newObject.setMoreItem(moreItem == null ? null : moreItem.clone());
		newObject.setRowGap(rowGap);
		newObject.setCellGap(cellGap);
		newObject.setRowCount(rowCount);
		newObject.setColumnCount(columnCount);
		newObject.setIndicator(indicator);
		newObject.setPagination(pagination);
		newObject.setIndicatorLocation(indicatorLocation);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRotatorList();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
	
	@Override
	public int getDefaultOrientation() {
		return OrientationType.Horizontal;
	}
}
