package com.bokesoft.yigo.meta.form.component.control.editview;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewItem;

public class MetaEditViewItemCollection extends GenericKeyCollection<MetaEditViewItem> {

	public static final String TAG_NAME = "EditViewItemCollection";
	/**
	 * 公式数据来源  
	 */
	private MetaBaseScript formulaItems;
	
	/**
	 * 获取公式数据来源 
	 *
	 * @return 公式数据来源
	 */
	public MetaBaseScript getFormulaItems() {
		return formulaItems;
	}

	/**
	 * 设置公式数据来源 
	 *
	 * @param formulaItems
	 *            公式数据来源
	 */
	public void setFormulaItems(MetaBaseScript formulaItems) {
		this.formulaItems = formulaItems;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] {formulaItems });
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
													String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equals(MetaConstants.COMBOBOX_FORMULAITEMS)) {
			this.formulaItems = new MetaBaseScript(MetaConstants.COMBOBOX_FORMULAITEMS);
			resultMetaObject = formulaItems;
		}else if (MetaEditViewItem.TAG_NAME.equals(tagName) || MetaListViewItem.TAG_NAME.equals(tagName)) {
			MetaEditViewItem item = new MetaEditViewItem();
			item.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(item);
			resultMetaObject = item;
		}
		return resultMetaObject;
	}

	@Override
	public boolean isStandaloneNode() {
		return false;
	}

	@Override
	public MetaEditViewItemCollection clone() {
		MetaEditViewItemCollection newObject = (MetaEditViewItemCollection) super.clone();
		newObject.setFormulaItems(formulaItems == null ? null : (MetaBaseScript) formulaItems.clone());
		return newObject;
	}

	@Override
	public MetaEditViewItemCollection newInstance() {
		return new MetaEditViewItemCollection();
	}
}
