package com.bokesoft.yigo.meta.form.component.control;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.DirectionType;
import com.bokesoft.yigo.common.def.TabMode;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

/**
 * MetaTabGroup定义选项组
 * @author wangyh
 *
 */
public class MetaTabGroup extends MetaComponent {
	/** 方位 */
	private Integer direction = DirectionType.BOTTOM;
	/** 模式 */
	private Integer tabMode = TabMode.Fixed;
	/** 指示器高度 */
	private DefSize indicatorHeight = null;
	/** 指示器颜色 */
	private String indicatorColor = "";
	/** 选项集合 */
	private MetaTabItemCollection itemCollection = null;

	/** 点击动画，移动端使用，目前值可用值为：1）Scale*/
	private String clickAnim = "";
	
	public MetaTabGroup() {
		super();
		this.itemCollection = new MetaTabItemCollection();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new Object[] {
				itemCollection
		});
	}
	
	@Override
	public int getControlType() {
		return ControlType.TABGROUP;
	}

	@Override
	public AbstractMetaObject getProperties() {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		if (itemCollection != null) {
			for (int i = 0; i < itemCollection.size(); i++) {
				MetaTabItem item = itemCollection.get(i);
				if (item.getKey() == null || item.getKey().isEmpty()) {
					item.setKey(this.getKey() + "_Item" + i);
				}
				item.doPostProcess(flag, callback);
			}
		}
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if ( resultMetaObject == null ) {
			resultMetaObject = itemCollection.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		return resultMetaObject;
	}

	public static final String TAG_NAME = "TabGroup";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTabGroup();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaTabGroup newObject = (MetaTabGroup)super.clone();
		newObject.setDirection(direction);
		newObject.setTabMode(tabMode);
		newObject.setIndicatorHeight(indicatorHeight);
		newObject.setIndicatorColor(indicatorColor);
		newObject.setClickAnim(clickAnim);
		newObject.setItemCollection(itemCollection == null ? null : (MetaTabItemCollection)itemCollection.clone());
		return newObject;
	}

	/**
	 * 设置方位
	 * @param direction 方位
	 */
	public void setDirection(Integer direction) {
		this.direction = direction;
	}
	
	/**
	 * 取得方位
	 * @return 方位
	 */
	public Integer getDirection() {
		return this.direction;
	}
	
	/**
	 * 设置模式
	 * @param tabMode 模式
	 */
	public void setTabMode(Integer tabMode) {
		this.tabMode = tabMode;
	}
	
	/**
	 * 取得模式
	 * @return 模式
	 */
	public Integer getTabMode() {
		return this.tabMode;
	}
	
	/**
	 * 设置指示器高度
	 * @param indicatorHeight 高度
	 */
	public void setIndicatorHeight(DefSize indicatorHeight) {
		this.indicatorHeight = indicatorHeight;
	}
	
	/**
	 * 取得指示器高度
	 * @return 高度
	 */
	public DefSize getIndicatorHeight() {
		return this.indicatorHeight;
	}
	
	/**
	 * 设置指示器颜色
	 * @param indicatorColor 指示器颜色
	 */
	public void setIndicatorColor(String indicatorColor) {
		this.indicatorColor = indicatorColor;
	}
	
	/**
	 * 取得指示器颜色
	 * @return 指示器颜色
	 */
	public String getIndicatorColor() {
		return this.indicatorColor;
	}
	
	/**
	 * 设置项目集合
	 * @param itemCollection 项目集合
	 */
	public void setItemCollection(MetaTabItemCollection itemCollection) {
		this.itemCollection = itemCollection;
	}
	
	/**
	 * 取得项目集合
	 * @return 项目集合
	 */
	public MetaTabItemCollection getItemCollection() {
		return this.itemCollection;
	}

	/**
	 * 获取点击动画
	 * @return 点击动画，移动端使用，目前值可用值为：1）Scale
	 */
	public String getClickAnim() {
		return clickAnim;
	}

	/**
	 * 设置点击动画
	 * @param clickAnim 点击动画，移动端使用，目前值可用值为：1）Scale
	 */
	public void setClickAnim(String clickAnim) {
		this.clickAnim = clickAnim;
	}

}
