package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSeparatorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextAreaProperties;

public class MetaSeparator extends MetaComponent {
	
	private MetaSeparatorProperties properties = null;
	
	public MetaSeparator() {
		this.properties = new MetaSeparatorProperties();
	}
	
	public static final String TAG_NAME = ControlType.STR_SEPARATOR;
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.SEPARATOR;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSeparator();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return this.properties;
	}
	
	/**
	 * 设置属性对象
	 *
	 * @param properties 属性对象
	 */
	@Override
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaSeparatorProperties) properties;
	}
	
	@Override
	public boolean receiveFocus() {
		return false;
	}

}
