package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaScoreBarProperties;

/**
 * 打分组件，默认情况下：打分项为五角星图案，共5个打分项，支持半分步进
 * @author chenzs
 *
 */
public class MetaScoreBar extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_SCOREBAR;
	private MetaScoreBarProperties properties = new MetaScoreBarProperties();

	@Override
	public int getControlType() {
		return ControlType.SCOREBAR;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return properties;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaScoreBar();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaScoreBar newObject = (MetaScoreBar) super.clone();
		newObject.setProperties(properties == null ? null : (MetaScoreBarProperties)properties.clone());
		return newObject;
	}

	/**
	 * 设置属性对象
	 * @param clone
	 */
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaScoreBarProperties) properties;
	}

	/**
	 * 获取打分的项目数量
	 * @return 打分的项目数量
	 */
	public Integer getCount() {
		return this.properties.getCount();
	}

	/**
	 * 设置打分的项目数量
	 * @param count 打分的项目数量
	 */
	public void setCount(Integer count) {
		this.properties.setCount(count);
	}

	/**
	 * 获取打分项未选中时的图标
	 * @return 打分项未选中时的图标
	 */
	public String getIcon() {
		return this.properties.getIcon();
	}

	/**
	 * 设置打分项未选中时的图标
	 * @param icon 打分项未选中时的图标
	 */
	public void setIcon(String icon) {
		this.properties.setIcon(icon);
	}

	/**
	 * 获取打分项选中时的图标
	 * @return 打分项选中时的图标
	 */
	public String getSelectIcon() {
		return this.properties.getSelectIcon();
	}

	/**
	 * 设置打分项选中时的图标
	 * @param selectIcon 打分项选中时的图标
	 */
	public void setSelectIcon(String selectIcon) {
		this.properties.setSelectIcon(selectIcon);
	}
	
	/**
	 * 设置是否支持半分步进
	 * @param supportHalf 是否支持半分步进
	 */
	public void setSupportHalf(Boolean supportHalf) {
		this.properties.setSupportHalf(supportHalf);
	}
	
	/**
	 * 获取是否支持半分步进
	 * @return 是否支持半分步进
	 */
	public Boolean isSupportHalf() {
		return properties.isSupportHalf();
	}
}
