package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaRelativeTimeProperties;

public class MetaRelativeTime extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_RELATIVETIME;

	private MetaRelativeTimeProperties properties = new MetaRelativeTimeProperties();

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.RELATIVETIME;
	}

	/**
	 * 设置自动更新时间
	 * 
	 * @param interval
	 *            自动更新时间
	 */
	public void setInterval(Integer interval) {
		properties.setInterval(interval);
	}

	/**
	 * 获取自动更新时间
	 * 
	 * @return 自动更新时间
	 */
	public Integer getInterval() {
		return properties.getInterval();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return properties;
	}

	@Override
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaRelativeTimeProperties) properties;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRelativeTime();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaRelativeTime newObject = (MetaRelativeTime) super.clone();
		newObject.setProperties((MetaRelativeTimeProperties) properties.clone());
		return newObject;
	}
}
