package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaProgressBarProperties;

/**
 * 进度条配置对象
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaProgressBar extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_PROGRESSBAR;

	public MetaProgressBarProperties properties = new MetaProgressBarProperties();

	public int getMaxPos() {
		return properties.getMaxPos();
	}

	public void setMaxPos(Integer maxPos) {
		properties.setMaxPos(maxPos);
	}

	public Integer getMinPos() {
		return properties.getMinPos();
	}

	public void setMinPos(Integer minPos) {
		properties.setMinPos(minPos);
	}

	public Integer getStepValue() {
		return properties.getStepValue();
	}

	public void setStepValue(Integer stepValue) {
		properties.setStepValue(stepValue);
	}

	public Boolean isDynamic() {
		return properties.isDynamic();
	}

	public void setDynamic(Boolean dynamic) {
		properties.setDynamic(dynamic);
	}

	public String getBarColor() {
		return properties.getBarColor();
	}

	public void setBarColor(String barColor) {
		properties.setBarColor(barColor);
	}

	public String getProgressColor() {
		return properties.getProgressColor();
	}

	public void setProgressColor(String progressColor) {
		properties.setProgressColor(progressColor);
	}

	public Integer getStyle() {
		return properties.getStyle();
	}

	public void setStyle(Integer style) {
		properties.setStyle(style);
	}

	public Boolean isRepeat() {
		return properties.isRepeat();
	}

	public void setRepeat(Boolean repeat) {
		properties.setRepeat(repeat);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.PROGRESSBAR;
	}

	@Override
	public boolean receiveFocus() {
		return false;
	}

	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaProgressBarProperties) properties;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaProgressBar newObject = (MetaProgressBar) super.clone();
		newObject.setProperties((MetaProgressBarProperties) properties.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaProgressBar();
	}

	@Override
	public AbstractMetaObject getProperties() {
		return properties;
	}
}
