package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFileChooserProperties;

public class MetaFileChooser extends MetaComponent {
	private MetaFileChooserProperties properties = new MetaFileChooserProperties();
	public MetaFileChooser() {
		super();
	}

	@Override
	public int getControlType() {
		return ControlType.FILECHOOSER;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return properties;
	}
	
	@Override
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaFileChooserProperties) properties;
	}

	/**
	 * 设置用途
	 * @param useType 用途，取值为Open和Save。
	 */
	public void setUseType(String useType) {
		this.properties.setUseType(useType);
	}
	
	/**
	 * 取得用途，取值为Open和Save。
	 * @return 用途
	 */
	public String getUseType() {
		return this.properties.getUseType();
	}
	
	/**
	 * 设置是否允许多选标志
	 * @param allowMulti 允许多选标志
	 */
	public void setAllowMulti(Boolean allowMulti) {
		this.properties.setAllowMulti(allowMulti);
	}
	
	/**
	 * 取得是否允许多选标志
	 * @return 允许多选标志
	 */
	public Boolean isAllowMulti() {
		return this.properties.isAllowMulti();
	}
	
	/**
	 * 设置扩展过滤
	 * @param extFilter 扩展过滤，以;分隔，比如xml;xls
	 */
	public void setExtFilter(String extFilter) {
		this.properties.setExtFilter(extFilter);
	}
	
	/**
	 * 取得扩展过滤
	 * @return 扩展过滤
	 */
	public String getExtFilter() {
		return this.properties.getExtFilter();
	}

	public static final String TAG_NAME = ControlType.STR_FILECHOOSER;
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFileChooser();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaFileChooser newObj = (MetaFileChooser)super.clone();
		newObj.setProperties(properties == null ? null : (MetaFileChooserProperties)properties.clone());
		return newObj;
	}
}
