package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCountUpProperties;

/**
 * 数字滚动组件的配置对象
 * 
 * @author chenzs
 *
 */
public class MetaCountUp extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_COUNTUP;

	/** 属性对象 */
	private MetaCountUpProperties properties;

	/**
	 * 构造函数
	 */
	public MetaCountUp() {
		properties = new MetaCountUpProperties();
	}

	/**
	 * 设置属性对象
	 * 
	 * @param properties
	 *            属性对象
	 */
	public void setProperties(MetaCountUpProperties properties) {
		this.properties = properties;
	}

	@Override
	public MetaCountUpProperties getProperties() {
		return this.properties;
	}

	@Override
	public int getControlType() {
		return ControlType.COUNTUP;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCountUp();
	}

}
