package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.BarCodeType;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaBarCoderProperties;

public class MetaBarCoder extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_BARCODER;
	protected MetaBarCoderProperties properties;

	public MetaBarCoder() {
		properties = new MetaBarCoderProperties();
	}

	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaBarCoderProperties) properties;
	}

	@Override
	public MetaBarCoderProperties getProperties() {
		return this.properties;
	}

	/**
	 * 设置条码类型
	 * 
	 * @param codeType
	 *            条码类型，值为{@link BarCodeType}
	 */
	public void setCodeType(Integer codeType) {
		this.properties.setCodeType(codeType);
	}

	/**
	 * 获取条码类型
	 * 
	 * @return 条码类型
	 */
	public Integer getCodeType() {
		return this.properties.getCodeType();
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.BARCODER;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaBarCoder newObject = (MetaBarCoder) super.clone();
		newObject.setProperties(properties.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBarCoder();
	}
}
