package com.bokesoft.yigo.meta.form.component.container;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.common.def.ContainerStyle;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaTabGroup;

public class MetaContainer extends MetaComponent {
	/**
	 * 容器样式，取值见{@link com.bokesoft.yigo.common.def.ContainerStyle}
	 */
	private Integer style = ContainerStyle.Tab;
	/** 默认打开的表单标识 */
	private String defaultFormKey = "";
	/** 表达式表示的表单标识，优先级高于defaultFormKey */
	private String formulaFormKey = "";
	/** 是否表单上的默认容器 */
	private Boolean isDefault = true;
	/** 是否合并操作至父界面 */
	private Boolean mergeOperation = false;
	/** 选项卡组 */
	private MetaTabGroup tabGroup = null;
	/** 参数列表 */
	private String parameters = "";
	
	public MetaContainer() {
		super();
	}
	
	@Override
	public boolean receiveFocus() {
		return false;
	}
	
	@Override
	public int getControlType() {
		return ControlType.CONTAINER;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new Object[] {
				tabGroup
		});
	}

	public static final String TAG_NAME = "Container";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if(tabGroup != null){
			tabGroup.doPostProcess(flag, callback);
		}
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if ( resultMetaObject == null ) {
			this.tabGroup = new MetaTabGroup();
			this.tabGroup.preProcessMetaObject(env, doc, node, flag, runType);
			resultMetaObject = this.tabGroup;
		}
		return resultMetaObject;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaContainer newObject = (MetaContainer)super.clone();
		newObject.setStyle(style);
		newObject.setDefaultFormKey(defaultFormKey);
		newObject.setFormulaFormKey(formulaFormKey);
		newObject.setDefault(isDefault);
		newObject.setTabGroup(tabGroup == null ? null : (MetaTabGroup)tabGroup.clone());
		newObject.setMergeOperation(mergeOperation);
		newObject.setParameters(parameters);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaContainer();
	}

	/**
	 * 设置样式
	 * @param style 样式
	 * @see #style
	 */
	public void setStyle(Integer style) {
		this.style = style;
	}
	
	/**
	 * 取得样式
	 * @return 样式
	 * @see #style
	 */
	public Integer getStyle() {
		return this.style;
	}
	
	/**
	 * 设置默认的表单标识
	 * @param defaultFormKey 表单标识
	 */
	public void setDefaultFormKey(String defaultFormKey) {
		this.defaultFormKey = defaultFormKey;
	}
	
	/**
	 * 取得默认的表单标识
	 * @return 表单标识
	 */
	public String getDefaultFormKey() {
		return this.defaultFormKey;
	}
	
	/**
	 * 设置表达式表示的表单标识
	 * @param formulaFormKey 表达式
	 */
	public void setFormulaFormKey(String formulaFormKey) {
		this.formulaFormKey = formulaFormKey;
	}
	
	/**
	 * 取得表达式表示的表单标识
	 * @return 表达式
	 */
	public String getFormulaFormKey() {
		return this.formulaFormKey;
	}
	
	/**
	 * 设置是否默认容器
	 * @param isDefault 默认标志
	 */
	public void setDefault(Boolean isDefault) {
		this.isDefault = isDefault;
	}
	
	/**
	 * 取得是否默认容器
	 * @return 默认标志
	 */
	public Boolean isDefault() {
		return this.isDefault;
	}
	
	/**
	 * 设置是否合并操作至父界面
	 * @param mergeOperation 标志
	 */
	public void setMergeOperation(Boolean mergeOperation) {
		this.mergeOperation = mergeOperation;
	}
	
	/**
	 * 取得是否合并操作至父界面
	 * @return 标志
	 */
	public Boolean isMergeOperation() {
		return this.mergeOperation;
	}
	
	/**
	 * 设置选项卡组
	 * @param tabGroup 选项卡组
	 */
	public void setTabGroup(MetaTabGroup tabGroup) {
		this.tabGroup = tabGroup;
	}
	
	/**
	 * 取得选项卡组
	 * @return 选项卡组
	 */
	public MetaTabGroup getTabGroup() {
		return this.tabGroup;
	}
	
	/**
	 * 设置参数列表
	 * @param parameters 参数列表
	 */
	public void setParameters(String parameters) {
		this.parameters = parameters;
	}
	
	/**
	 * 取得参数列表
	 * @return 参数列表
	 */
	public String getParameters() {
		return this.parameters;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}
	@Override
	public void merge(MetaComponent meta) {
		super.merge(meta);
		MetaContainer metaContainer = (MetaContainer) meta;
		if (style == -1){
			this.style = metaContainer.getStyle();
		}
		if (defaultFormKey == null){
			this.defaultFormKey = metaContainer.getDefaultFormKey();
		}
		if (formulaFormKey == null){
			this.formulaFormKey = metaContainer.getFormulaFormKey();
		}
		if (isDefault == null){
			this.isDefault = metaContainer.isDefault();
		}
		if (mergeOperation == null){
			this.mergeOperation = metaContainer.isMergeOperation();
		}
		if (parameters == null){
			this.parameters = metaContainer.getParameters();
		}
	}
}
