package com.bokesoft.yigo.meta.form;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;

/**
 * 窗口控件对象的构造块
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaBlock extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = "Block";

	/** 根组件 */
	private MetaComponent root = null;

	private Boolean isRoot = true;

	/**
	 * 设置根组件
	 * 
	 * @param root
	 *            根组件
	 */
	public void setRoot(MetaComponent root) {
		this.root = root;
	}

	public MetaComponent getRoot() {
		return this.root;
	}

	public void setIsRoot(Boolean isRoot) {
		this.isRoot = isRoot;
	}

	public Boolean isRoot() {
		return this.isRoot;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { root });
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		MetaComponent control = MetaComponentFactory.getInstance().newComponent(tagName);
		control.preProcessMetaObject(env, doc, node, flag, runType);
		this.addComponent(control);
		root = control;
		return control;
	}

	@Override
	public int getControlType() {
		return ControlType.BLOCK;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaBlock newObject = (MetaBlock) super.clone();
		newObject.setIsRoot(isRoot);
		newObject.setRoot(root == null ? null : (MetaComponent) root.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBlock();
	}
	
	@Override
	public boolean needCheckExtend() {
		return false;
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		if (root != null) {
			root.doPostProcess(flag, callback);
		}
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}

	/**
	 * 获取子控件总数
	 * 
	 * @return 总数
	 */
	public int getComponentCount() {
		return this.root == null ? 0 : 1;
	}

	/**
	 * 取得子控件
	 * 
	 * @param index
	 *            序号
	 * @return 组件
	 */
	public MetaComponent getComponent(int index) {
		return this.root;
	}
	
}
