package com.bokesoft.yigo.meta.flatcanvas.common;

import com.bokesoft.yigo.meta.flatcanvas.struct.FCAttrNames;

/**
 * 平面图配置对象属性项
 * 
 * @author chenbinbin
 *
 */
public class AttributeItem {

	/** 属性标志 */
	private String key = "";
	
	/** 属性变化监听 */
	private IChangeListener changeListener = null;
	
	private ValueProperty<Object> valueProperty = new ValueProperty<Object>();
	
	public AttributeItem(String key, Object value) {
		this.key = key;
		valueProperty.set(value);
		valueProperty.setChangeListener(new IChangeListener() {
			@Override
			public void fireChanged() {
				changeListener.fireChanged();
			}
		});
	}
	
	/**
	 * 获取属性标识
	 * 
	 * @return 属性标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置属性值
	 * 
	 * @param v 属性值
	 */
	public void setValue(Object v) {
		valueProperty.set(v);
	}
	
	/**
	 * 获取属性值
	 * 
	 * @return 属性值
	 */
	public Object getValue() {
		return valueProperty.get();
	}
	
	/**
	 * 设置属性变化监听
	 * 
	 * @param changeListener 属性变化监听
	 */
	public void setChangeListener(IChangeListener changeListener) {
		this.changeListener = changeListener; 
	}
	
	/**
	 * 是否为主键属性
	 * 
	 * @return 是否为主键属性
	 */
	public boolean isPrimary() {
		return FCAttrNames.ATTR_id.equalsIgnoreCase(key)
				|| FCAttrNames.ATTR_key.equalsIgnoreCase(key);
	}
}
