package com.bokesoft.yigo.meta.factory;

import java.util.Map;

import com.bokesoft.yigo.meta.base.IMetaResolver;

/**
 * IMetaResolverFactory用于隔离资源获取
 * @author wangyh
 *
 */
public interface IMetaResolverFactory {
	/**
	 * 初始化自定义参数
	 * @param paras 自定义参数
	 */
	public void initParas(Map<String, Object> paras);
	/**
	 * 取得应用路径
	 * @return 应用路径
	 */
	public String getSolutionPath();
	/**
	 * 新建以相对标识表示的资源加载器
	 * @param prefix 资源前缀
	 * @return 资源处理器
	 */
	public IMetaResolver newMetaResolver(String prefix);
	/**
	 * 新建以绝对标识表示的资源加载器，只在文件系统中有效，来源于网络的无效
	 * @param prefix 资源前缀
	 * @return 资源处理器
	 */
	public IMetaResolver newFileMetaResolver(String prefix);
	/**
	 * 取得分隔符，主要是jar包只能用/，又不想硬编码
	 * @return 分隔符
	 */
	public char getSeparator();
	/**
	 * 获取当前solution的版本号，默认为null
	 * @return 当前solution的版本号
	 */
	default public String getSolutionVersion() {
		return null;
	}
	
}
