package com.bokesoft.yigo.meta.factory;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ConcurrentHashMap;

import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.strings.MetaStringTable;
import com.bokesoft.yigo.meta.strings.MetaStringTableProfile;
/**
 * 用来处理所有延迟加载的多语言,工程下非延迟加载的直接读取到工程
 * @author 陈瑞
 *
 */
public class GlobalI18N {

	/** 表单字符串*/
	private Map<String, MetaStringTable> formStringsMap = null;
	private Map<String, List<MetaStringTableProfile>> formProfileMap = null;
	
	/** 流程字符串*/
	private Map<String, MetaStringTable> processStringsMap = null;
	private Map<String, List<MetaStringTableProfile>> processProfileMap = null;
	
	/** 数据对象字符串 */
	private Map<String, MetaStringTable> dataObjectStringsMap= null;
	private Map<String, List<MetaStringTableProfile>> dataObjectProfileMap = null;
	
	/** 应用定义的多语言文件*/
	private List<MetaStringTableProfile> solutionMultiLangList = null;
	/** 应用多语言字符串表 */
	private MetaStringTable strings = null;
	
	/** 应用定义的数据映射多语言文件*/
	private List<MetaStringTableProfile> solutionMapMultiLangList = null;
	/** 应用数据映射多语种字符串*/
	private MetaStringTable mapStrings = null;
	
	/** 应用定义的数据迁移多语言文件*/
	private List<MetaStringTableProfile> solutionMigrationMultiLangList = null;
	/** 应用数据迁移多语种字符串*/
	private MetaStringTable migrationStrings = null;
	
	public GlobalI18N() {
		formStringsMap = new ConcurrentHashMap<>();
		formProfileMap = new ConcurrentHashMap<>();
		processStringsMap = new ConcurrentHashMap<>();
		processProfileMap = new ConcurrentHashMap<>();
		dataObjectStringsMap = new ConcurrentHashMap<>();
		dataObjectProfileMap = new ConcurrentHashMap<>();
		solutionMultiLangList = new CopyOnWriteArrayList<MetaStringTableProfile>();
		solutionMapMultiLangList = new CopyOnWriteArrayList<MetaStringTableProfile>();
		solutionMigrationMultiLangList = new CopyOnWriteArrayList<MetaStringTableProfile>();
	}
	
	public void addSolutionProfile(MetaStringTableProfile profile) {
		this.solutionMultiLangList.add(profile);
	}
	
	public void addSolutionMapProfile(MetaStringTableProfile profile) {
		this.solutionMapMultiLangList.add(profile);
	}
	
	public void addSolutionMigrationProfile(MetaStringTableProfile profile) {
		this.solutionMigrationMultiLangList.add(profile);
	}
	
	public void clearSolutionI18N() {
		this.solutionMultiLangList.clear();
		this.solutionMapMultiLangList.clear();
		this.solutionMigrationMultiLangList.clear();
		this.strings = null;
		this.mapStrings = null;
		this.migrationStrings = null;
	}
	
	/**
	 * 加载所有
	 * @throws Throwable
	 */
	public void loadAll() throws Throwable {
		// 应用多语种
		getSolutionStrings();
		
		// 应用定义的数据映射多语言
		getSolutionMapStrings();
		
		// 应用定义的数据迁移多语言
		getSolutionMigrationStrings();
		
		// 工程下流程多语种
		loadAllBPMString();
		
		// 工程下数据对象多语种
		loadAllDataObjectStrings();
	}
	
	public MetaStringTable getSolutionStrings() throws Throwable {
		if( strings == null ) {
			strings = __load__(solutionMultiLangList, new MetaStringTable());
		}
		return strings;
	}

	public void setSolutionStrings(MetaStringTable strings) throws Throwable {
		this.strings = strings;
	}

	public MetaStringTable getSolutionStrings(String lang) throws Throwable {
		if( strings == null ) {
			strings = __load__(solutionMultiLangList, new MetaStringTable(), lang);
		}
		return strings;
	}

	public MetaStringTable getSolutionMapStrings() throws Throwable {
		if( mapStrings == null ) {
			mapStrings = __load__(solutionMultiLangList, new MetaStringTable());
		}
		return mapStrings;
	}
	
	public MetaStringTable getSolutionMigrationStrings() throws Throwable {
		if( migrationStrings == null ) {
			migrationStrings = __load__(solutionMultiLangList, new MetaStringTable());
		}
		return migrationStrings;
	}
	
	public void addFormProfile(String formKey, MetaStringTableProfile profile) {
		List<MetaStringTableProfile> list = formProfileMap.get(formKey);
		if( list == null ) {
			list = new CopyOnWriteArrayList<MetaStringTableProfile>();
			formProfileMap.put(formKey, list);
		}
		list.add(profile);
	}
	
	public MetaStringTable getFormStrings(String formKey) throws Throwable {
		MetaStringTable strings = formStringsMap.get(formKey);
		if( strings == null ) {
			strings = loadFormStrings(formKey);
		}
		return strings;
	}
	
	public void addProcessProfile(String processKey, MetaStringTableProfile profile) {
		List<MetaStringTableProfile> list = processProfileMap.get(processKey);
		if( list == null ) {
			list = new CopyOnWriteArrayList<MetaStringTableProfile>();
			processProfileMap.put(processKey, list);
		}
		list.add(profile);
	}
	
	public MetaStringTable getProcessStrings(String processKey) throws Throwable {
		MetaStringTable strings = processStringsMap.get(processKey);
		if( strings == null ) {
			strings = loadProcessStrings(processKey);
		}
		return strings;
	}
	
	public void addDataObjectProfile(String dataObjectKey, MetaStringTableProfile profile) {
		List<MetaStringTableProfile> list = dataObjectProfileMap.get(dataObjectKey);
		if( list == null ) {
			list = new CopyOnWriteArrayList<MetaStringTableProfile>();
			dataObjectProfileMap.put(dataObjectKey, list);
		}
		list.add(profile);
	}
	
	public MetaStringTable getDataObjectStrings(String dataObjectKey) throws Throwable {
		MetaStringTable strings = dataObjectStringsMap.get(dataObjectKey);
		if( strings == null ) {
			strings = loadDataObjectStrings(dataObjectKey);
		}
		return strings;
	}
	
	public void loadAllBPMString() throws Throwable {
		processStringsMap.clear();
		Set<String> keySet = processProfileMap.keySet();
		for( String key : keySet ) {
			List<MetaStringTableProfile> list = processProfileMap.get(key);
			MetaStringTable strings = __load__(list, new MetaStringTable());
			processStringsMap.put(key, strings);
		}
	}
	
	public void loadAllDataObjectStrings() throws Throwable {
		dataObjectStringsMap.clear();
		Set<String> keySet = dataObjectProfileMap.keySet();
		for( String key : keySet ) {
			List<MetaStringTableProfile> list = dataObjectProfileMap.get(key);
			MetaStringTable strings = __load__(list, new MetaStringTable());
			dataObjectStringsMap.put(key, strings);
		}
	}
	
	private MetaStringTable loadFormStrings(String formKey) throws Throwable {
		MetaStringTable strings = new MetaStringTable();
		List<MetaStringTableProfile> list = formProfileMap.get(formKey);
		if( list != null ) {
			formStringsMap.put(formKey, __load__(list, strings));
		}
		return strings;
	}
	
	private MetaStringTable loadProcessStrings(String processKey) throws Throwable {
		MetaStringTable strings = new MetaStringTable();
		List<MetaStringTableProfile> list = processProfileMap.get(processKey);
		if( list != null ) {
			processStringsMap.put(processKey, __load__(list, strings));
		}
		return strings;
	}
	
	private MetaStringTable loadDataObjectStrings(String dataObjectKey) throws Throwable {
		MetaStringTable strings = new MetaStringTable();
		List<MetaStringTableProfile> list = dataObjectProfileMap.get(dataObjectKey);
		if( list != null ) {
			dataObjectStringsMap.put(dataObjectKey, __load__(list, strings));
		}
		return strings;
	}
	
	private MetaStringTable __load__(List<MetaStringTableProfile> list,MetaStringTable strings) throws Throwable {
		for( MetaStringTableProfile profile : list ) {
			String filePath = profile.getFilePath();
			String lang = profile.getLang();
			IMetaResolver resolver = profile.getResolver();
			InputStream in = resolver.read(filePath, 0);
			strings.load(lang, in);
			in.close();
		}
		return strings;
	}

	private MetaStringTable __load__(List<MetaStringTableProfile> list,MetaStringTable strings, String key) throws Throwable {
		for( MetaStringTableProfile profile : list ) {
			String filePath = profile.getFilePath();
			String lang = profile.getLang();
			if (!lang.equals(key)) {
				continue;
			}
			IMetaResolver resolver = profile.getResolver();
			InputStream in = resolver.read(filePath, 0);
			strings.load(lang, in);
			in.close();
		}
		return strings;
	}

}
